/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.messages;

import org.coodex.concrete.client.MessageSubscriber;
import org.coodex.concrete.common.BeanProviderFacade;
import org.coodex.concrete.common.ConcreteContext;
import org.coodex.concrete.common.JSONSerializerFactory;
import org.coodex.concrete.common.ServiceContext;
import org.coodex.concrete.common.Token;
import org.coodex.concrete.common.messages.Message;
import org.coodex.concrete.common.messages.MessageFilter;
import org.coodex.concrete.common.messages.Subscription;
import org.coodex.concrete.core.messages.AbstractSubscription;
import org.coodex.concrete.core.messages.Courier;
import org.coodex.concrete.core.messages.TokenBaseMessageFilter;
import org.coodex.concrete.core.token.TokenManager;
import org.coodex.concrete.core.token.TokenWrapper;

public class TokenBaseSubscription<T>
extends AbstractSubscription<T> {
    private final String tokenId;
    private final Courier courier;

    public TokenBaseSubscription(String subject) {
        this(subject, (TokenBaseMessageFilter<T>)null);
    }

    public TokenBaseSubscription(String subject, TokenBaseMessageFilter<T> filter) {
        super(subject, filter);
        ServiceContext context = ConcreteContext.getServiceContext();
        if (context.getSide() == 1) {
            this.tokenId = null;
        } else {
            Token token = TokenWrapper.getInstance();
            if (token == null || !token.isValid()) {
                throw new RuntimeException("invalid token.");
            }
            this.tokenId = token.getTokenId();
            if (context.getCourier() == null) {
                throw new RuntimeException("no courier found.");
            }
        }
        this.courier = context.getCourier();
    }

    @Override
    public MessageFilter<? super T> getFilter() {
        return super.getFilter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message<T> message) {
        if (this.tokenId != null) {
            Token token = BeanProviderFacade.getBeanProvider().getBean(TokenManager.class).getToken(this.tokenId, false);
            if (token == null || !token.isValid()) {
                if (this.subscriber != null) {
                    this.subscriber.cancel();
                }
                return;
            }
            Token token2 = token;
            synchronized (token2) {
                this.courier.pushTo(message, token);
            }
        } else {
            MessageSubscriber.next(message.getSubject(), JSONSerializerFactory.getInstance().toJson(message.getBody()));
        }
    }

    @Override
    public boolean isSame(Subscription anotherSubscription) {
        if (!(anotherSubscription instanceof TokenBaseSubscription)) {
            return false;
        }
        TokenBaseSubscription that = (TokenBaseSubscription)anotherSubscription;
        if (this.tokenId != null ? !this.tokenId.equals(that.tokenId) : that.tokenId != null) {
            return false;
        }
        if (!this.courier.getType().equals(that.courier.getType())) {
            return false;
        }
        return super.isSame(anotherSubscription);
    }
}

