/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.mocker;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.coodex.concrete.api.mockers.DateTime;
import org.coodex.pojomocker.AbstractMocker;

public class DateTimeMocker
extends AbstractMocker<DateTime> {
    public Object mock(DateTime mockAnnotation, Class clazz) {
        try {
            long dateTime;
            SimpleDateFormat format = new SimpleDateFormat(mockAnnotation.format());
            long min = 0L;
            long max = Long.MAX_VALUE;
            if (mockAnnotation.min().length() > 0) {
                min = format.parse(mockAnnotation.min()).getTime();
            }
            if (mockAnnotation.max().length() > 0) {
                max = format.parse(mockAnnotation.max()).getTime();
            }
            long l = dateTime = min == max ? min : (long)(Math.random() * (double)(Math.max(max, min) - Math.min(max, min))) + Math.min(max, min);
            if (Date.class.equals((Object)clazz)) {
                return new Date(dateTime);
            }
            if (Calendar.class.equals((Object)clazz)) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(dateTime);
                return calendar;
            }
            if (String.class.equals((Object)clazz)) {
                return format.format(new Date(dateTime));
            }
            return null;
        }
        catch (Throwable th) {
            throw new RuntimeException(th.getLocalizedMessage(), th);
        }
    }
}

