/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.signature;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.coodex.concrete.common.ConcreteException;
import org.coodex.concrete.common.SignatureSerializer;
import org.coodex.util.Common;
import org.coodex.util.PojoInfo;
import org.coodex.util.PojoProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSignatureSerializer
implements SignatureSerializer {
    private static final Logger log = LoggerFactory.getLogger(DefaultSignatureSerializer.class);
    private static final Class[] PRIMITIVE_CLASS = new Class[]{String.class, Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Void.class, Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Void.TYPE};

    public byte[] serialize(Map<String, Object> values) {
        if (values == null && values.size() == 0) {
            return new byte[0];
        }
        return this.toSign(values).getBytes();
    }

    private String joint(String key, Object o, boolean first) {
        if (o == null) {
            return null;
        }
        Class<?> c = o.getClass();
        String s = null;
        if (c.isArray()) {
            s = this.jointArray(key, Arrays.asList((Object[])o));
        } else if (List.class.isAssignableFrom(c)) {
            s = this.jointArray(key, (List)o);
        } else if (Set.class.isAssignableFrom(c)) {
            Object[] objects = ((Set)o).toArray();
            Arrays.sort(objects);
            s = this.jointArray(key, Arrays.asList(objects));
        } else {
            s = Common.inArray(c, (Object[])PRIMITIVE_CLASS) ? DefaultSignatureSerializer.encode(key) + "=" + DefaultSignatureSerializer.encode(Double.TYPE.equals(c) || Double.class.equals(c) ? String.format("%.6f", o) : o.toString()) : this.jointPojo(key, o);
        }
        return Common.isBlank((String)s) ? null : (first ? "" : "&") + s;
    }

    private String jointArray(String key, List<Object> list) {
        StringBuilder builder = new StringBuilder();
        boolean isFirst = true;
        for (Object o : list) {
            String joint;
            if (o == null || Common.isBlank((String)(joint = this.joint(key, o, isFirst)))) continue;
            builder.append(joint);
            isFirst = false;
        }
        return builder.toString();
    }

    private Object getValue(PojoProperty pojoProperty, Object o) throws InvocationTargetException, IllegalAccessException {
        Method method = pojoProperty.getMethod();
        if (method != null) {
            method.setAccessible(true);
            return method.invoke(o, new Object[0]);
        }
        Field field = pojoProperty.getField();
        if (field != null) {
            field.setAccessible(true);
            return field.get(o);
        }
        return null;
    }

    private String jointPojo(String key, Object o) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        PojoInfo pojoInfo = new PojoInfo(o.getClass(), new Type[0]);
        for (PojoProperty pojoProperty : pojoInfo.getProperties()) {
            String propertyName = pojoProperty.getName();
            try {
                map.put(propertyName, this.getValue(pojoProperty, o));
            }
            catch (InvocationTargetException e) {
                log.error("unable to get field value : {}", (Object)propertyName);
                throw new ConcreteException(99999, e.getLocalizedMessage());
            }
            catch (IllegalAccessException e) {
                log.error("unable to get field value : {}", (Object)propertyName);
                throw new ConcreteException(99999, e.getLocalizedMessage());
            }
        }
        String s = this.toSign(map);
        return Common.isBlank((String)s) ? null : DefaultSignatureSerializer.encode(key) + "=" + DefaultSignatureSerializer.encode(s);
    }

    private String toSign(Map<String, Object> map) {
        StringBuilder builder = new StringBuilder();
        Object[] keys = map.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        boolean isFirst = true;
        for (Object key : keys) {
            String joint = this.joint((String)key, map.get(key), isFirst);
            if (Common.isBlank((String)joint)) continue;
            builder.append(joint);
            isFirst = false;
        }
        return builder.toString();
    }

    private static String encode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.warn(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }
}

