/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.signature;

import java.util.Arrays;
import org.coodex.concrete.common.ConcreteException;
import org.coodex.concrete.common.ConcreteServiceLoader;
import org.coodex.concrete.common.IF;
import org.coodex.concrete.core.signature.AbstractIronPen;
import org.coodex.concrete.core.signature.HmacKeyStore;
import org.coodex.concrete.core.signature.SignUtil;
import org.coodex.util.DigestHelper;
import org.coodex.util.ServiceLoader;

public class HmacPen
extends AbstractIronPen {
    private static final ServiceLoader<HmacKeyStore> HMAC_KEY_STORE_PROVIDERS = new ConcreteServiceLoader<HmacKeyStore>(){

        @Override
        public HmacKeyStore getConcreteDefaultProvider() {
            return new HmacKeyStore(){

                @Override
                public byte[] getHmacKey(String paperName, String keyId) {
                    String s = this.getHmacKeyStr(paperName, keyId);
                    return s == null ? null : s.getBytes();
                }

                private String getHmacKeyStr(String paperName, String keyId) {
                    if (keyId == null) {
                        return SignUtil.getString("hmacKey", paperName, null);
                    }
                    String key = SignUtil.PROFILE.getString("hmacKey." + paperName + "." + keyId);
                    if (key == null) {
                        key = SignUtil.PROFILE.getString("hmacKey." + paperName);
                    }
                    return key == null ? SignUtil.getString("hmacKey", keyId, null) : key;
                }
            };
        }
    };

    HmacPen(String paperName) {
        super(paperName);
    }

    private byte[] getHmacKey(String keyId) {
        return ((HmacKeyStore)HMAC_KEY_STORE_PROVIDERS.getInstance()).getHmacKey(this.paperName, keyId);
    }

    public byte[] sign(byte[] content, String algorithm, String keyId) {
        return this.sign(content, IF.isNull(this.getHmacKey(keyId), 1015, "invalid HMAC Key"), algorithm);
    }

    private byte[] sign(byte[] content, byte[] key, String algorithm) {
        try {
            return DigestHelper.hmac((byte[])content, (byte[])key, (String)algorithm);
        }
        catch (Throwable th) {
            throw new ConcreteException(99999, th.getLocalizedMessage(), th);
        }
    }

    public boolean verify(byte[] content, byte[] signature, String algorithm, String keyId) {
        return Arrays.equals(signature, this.sign(content, IF.isNull(this.getHmacKey(keyId), 1016, "invalid HMAC Key"), algorithm));
    }
}

