/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.signature;

import org.coodex.concrete.api.Signable;
import org.coodex.concrete.client.ClientServiceContext;
import org.coodex.concrete.common.ConcreteContext;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.ConcreteServiceLoader;
import org.coodex.concrete.common.DefinitionContext;
import org.coodex.concrete.common.IronPenFactory;
import org.coodex.concrete.common.ServiceContext;
import org.coodex.concrete.common.SignatureSerializer;
import org.coodex.concrete.core.signature.DefaultSignatureSerializer;
import org.coodex.util.AcceptableServiceLoader;
import org.coodex.util.Common;
import org.coodex.util.Profile;
import org.coodex.util.ServiceLoader;
import org.coodex.util.ServiceLoaderFacade;

public class SignUtil {
    private static final String TAG_SIGNATRUE = "signature";
    public static final Profile PROFILE = ConcreteHelper.getProfile("signature");
    private static final AcceptableServiceLoader<String, IronPenFactory> IRON_PEN_FACTORY_CONCRETE_SPI_FACADE = new AcceptableServiceLoader((ServiceLoaderFacade)new ConcreteServiceLoader<IronPenFactory>(){});
    private static final SignatureSerializer DEFAULT_SERIALIZER = new DefaultSignatureSerializer();
    private static final ServiceLoader<SignatureSerializer> SIGNATURE_SERIALIZER_CONCRETE_SPI_FACADE = new ConcreteServiceLoader<SignatureSerializer>(){

        @Override
        public SignatureSerializer getConcreteDefaultProvider() {
            return DEFAULT_SERIALIZER;
        }
    };

    private static String getString(Profile profile, String key, String paperName) {
        return Common.isBlank((String)paperName) ? profile.getString(key) : profile.getString(key + "." + paperName);
    }

    public static String getString(String key, String paperName, String defaultValue) {
        String module;
        ServiceContext serviceContext = ConcreteContext.getServiceContext();
        String value = null;
        if (serviceContext instanceof ClientServiceContext && !Common.isBlank((String)(module = ((ClientServiceContext)serviceContext).getDestination().getIdentify()))) {
            value = SignUtil.getString(ConcreteHelper.getProfile(TAG_SIGNATRUE, module), key, paperName);
        }
        if (value == null) {
            value = SignUtil.getString(ConcreteHelper.getProfile(TAG_SIGNATRUE), key, paperName);
        }
        return value == null ? defaultValue : value;
    }

    public static HowToSign howToSign(Signable signable) {
        String algorithm = SignUtil.getString("algorithm", signable.paperName(), signable.algorithm());
        return new HowToSign((IronPenFactory)IRON_PEN_FACTORY_CONCRETE_SPI_FACADE.getServiceInstance((Object)algorithm), signable.serializer().equals(SignatureSerializer.class) ? DEFAULT_SERIALIZER : (SignatureSerializer)SIGNATURE_SERIALIZER_CONCRETE_SPI_FACADE.getInstance(signable.serializer()), signable.paperName(), algorithm);
    }

    public static HowToSign howToSign(DefinitionContext context) {
        return SignUtil.howToSign((Signable)context.getAnnotation(Signable.class));
    }

    public static class HowToSign {
        private final IronPenFactory ironPenFactory;
        private final SignatureSerializer serializer;
        private final String paperName;
        private final String algorithm;

        HowToSign(IronPenFactory ironPenFactory, SignatureSerializer serializer, String paperName, String algorithm) {
            this.ironPenFactory = ironPenFactory;
            this.serializer = serializer;
            this.paperName = Common.isBlank((String)paperName) ? null : paperName;
            this.algorithm = algorithm;
        }

        public String getPaperName() {
            return this.paperName;
        }

        @Deprecated
        public IronPenFactory getIronPenFactory() {
            return this.getIronPenFactory(null);
        }

        public IronPenFactory getIronPenFactory(String algorithm) {
            return algorithm == null ? this.ironPenFactory : (IronPenFactory)IRON_PEN_FACTORY_CONCRETE_SPI_FACADE.getServiceInstance((Object)algorithm);
        }

        public SignatureSerializer getSerializer() {
            return this.serializer;
        }

        public String getAlgorithm() {
            return this.algorithm;
        }
    }
}

