/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.token;

import java.util.List;
import org.coodex.concrete.common.ConcreteServiceLoader;
import org.coodex.concrete.common.Token;
import org.coodex.concrete.common.TokenEventListener;
import org.coodex.concrete.core.token.ReadOnlyToken;
import org.coodex.util.AcceptableServiceLoader;
import org.coodex.util.ServiceLoaderFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractToken
implements Token {
    private static final AcceptableServiceLoader<Token.Event, TokenEventListener> LISTENER_LOADER = new AcceptableServiceLoader((ServiceLoaderFacade)new ConcreteServiceLoader<TokenEventListener>(){});
    private static final Logger log = LoggerFactory.getLogger(AbstractToken.class);

    protected final void runListeners(Token.Event event, boolean before) {
        List listeners = LISTENER_LOADER.getServiceInstances((Object)event);
        if (listeners.size() > 0) {
            ReadOnlyToken token = new ReadOnlyToken(this);
            for (TokenEventListener listener : listeners) {
                try {
                    if (before) {
                        listener.before((Token)token);
                        continue;
                    }
                    listener.after((Token)token);
                }
                catch (Throwable th) {
                    log.warn("error occurred on {} {} listener  [{}]: {}", new Object[]{before ? "before" : "after", event.toString(), listener.getClass(), th.getLocalizedMessage(), th});
                }
            }
        }
    }

    public final void invalidate() {
        this.runListeners(Token.Event.INVALIDATED, true);
        this.$invalidate();
        this.runListeners(Token.Event.INVALIDATED, false);
    }

    protected abstract void $invalidate();

    public final void renew() {
        if (this.isValid()) {
            this.invalidate();
        }
        this.runListeners(Token.Event.CREATED, true);
        this.$renew();
        this.runListeners(Token.Event.CREATED, false);
    }

    @Deprecated
    public <T> T getAttribute(String key) {
        return (T)this.getAttribute(key, null);
    }

    protected abstract void $renew();
}

