/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.token;

import java.io.Serializable;
import java.util.Enumeration;
import org.coodex.concrete.common.Account;
import org.coodex.concrete.common.AccountID;
import org.coodex.concrete.common.ConcreteContext;
import org.coodex.concrete.common.IF;
import org.coodex.concrete.common.Token;

public class TokenWrapper
implements Token {
    private static final Token singletonInstance = new TokenWrapper();

    private Token getToken() {
        return this.getToken(true);
    }

    private Token getToken(boolean checkValidation) {
        Token token = ConcreteContext.getServiceContext().getToken();
        IF.isNull(token, 1003, new Object[0]);
        IF.is(checkValidation && !token.isValid(), 1004, token.getTokenId());
        return token;
    }

    public static final Token getInstance() {
        return singletonInstance;
    }

    public void renew() {
        this.getToken(false).renew();
    }

    public long created() {
        return this.getToken().created();
    }

    public boolean isValid() {
        return this.getToken(false).isValid();
    }

    public void invalidate() {
        this.getToken().invalidate();
    }

    public <ID extends AccountID> Account<ID> currentAccount() {
        return this.getToken().currentAccount();
    }

    public void setAccount(Account account) {
        this.getToken().setAccount(account);
    }

    public boolean isAccountCredible() {
        return this.getToken().isAccountCredible();
    }

    public void setAccountCredible(boolean credible) {
        this.getToken().setAccountCredible(credible);
    }

    public String getTokenId() {
        return this.getToken(false).getTokenId();
    }

    @Deprecated
    public <T> T getAttribute(String key) {
        return (T)this.getToken().getAttribute(key);
    }

    public <T> T getAttribute(String key, Class<T> clz) {
        return (T)this.getToken().getAttribute(key, clz);
    }

    public void setAttribute(String key, Serializable attribute) {
        this.getToken().setAttribute(key, attribute);
    }

    public void removeAttribute(String key) {
        this.getToken().removeAttribute(key);
    }

    public Enumeration<String> attributeNames() {
        return this.getToken().attributeNames();
    }

    public void flush() {
        this.getToken().flush();
    }
}

