/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.common;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.coodex.closure.CallableClosure;
import org.coodex.closure.ClosureContext;
import org.coodex.closure.StackClosureContext;
import org.coodex.concrete.client.ClientSideContext;
import org.coodex.concrete.common.BeanServiceLoaderProvider;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.ServiceContext;
import org.coodex.concrete.core.intercept.ConcreteInterceptor;
import org.coodex.concrete.core.intercept.ConcreteMethodInvocation;
import org.coodex.concrete.core.intercept.InterceptorChain;
import org.coodex.concrete.core.intercept.SyncInterceptorChain;
import org.coodex.util.ServiceLoaderImpl;
import org.coodex.util.Singleton;

public final class ConcreteContext {
    public static final String KEY_TOKEN = "CONCRETE-TOKEN-ID";
    public static final String KEY_LOCALE = "CONCRETE-LOCALE";
    private static final ClosureContext<ServiceContext> CONTEXT = new StackClosureContext();
    public static final ClosureContext<Map<String, Object>> LOGGING = new StackClosureContext();
    private static Singleton<SyncInterceptorChain> interceptorChainSingleton = new Singleton(() -> {
        SyncInterceptorChain syncInterceptorChain = new SyncInterceptorChain();
        ServiceLoaderImpl<ConcreteInterceptor> serviceLoader = new ServiceLoaderImpl<ConcreteInterceptor>(){};
        for (ConcreteInterceptor interceptor : serviceLoader.getAll().values()) {
            if (interceptor instanceof InterceptorChain) continue;
            syncInterceptorChain.add(interceptor);
        }
        return syncInterceptorChain;
    });
    private static Map<String, Object> emptyLogging = new Map<String, Object>(){

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean containsKey(Object key) {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        public Object get(Object key) {
            return null;
        }

        @Override
        public Object put(String key, Object value) {
            return null;
        }

        @Override
        public Object remove(Object key) {
            return null;
        }

        @Override
        public void putAll(Map<? extends String, ?> m) {
        }

        @Override
        public void clear() {
        }

        @Override
        public Set<String> keySet() {
            return new HashSet<String>();
        }

        @Override
        public Collection<Object> values() {
            return new HashSet<Object>();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return new HashSet<Map.Entry<String, Object>>();
        }
    };

    public static final ServiceContext getServiceContext() {
        return (ServiceContext)CONTEXT.get();
    }

    public static final void putLoggingData(String key, Object value) {
        ConcreteContext.getLogging().put(key, value);
    }

    public static final Map<String, Object> getLoggingData() {
        return ConcreteContext.getLogging();
    }

    private static final Map<String, Object> getLogging() {
        Map logging = (Map)LOGGING.get();
        return logging == null ? emptyLogging : logging;
    }

    public static final Object runWithContext(ServiceContext context, CallableClosure callable) {
        try {
            return CONTEXT.call((Object)context, callable);
        }
        catch (Throwable throwable) {
            throw ConcreteHelper.getException(throwable);
        }
    }

    public static final Object runServiceWithContext(ServiceContext context, final CallableClosure callable, final Class<?> interfaceClass, Method method, Object[] params) {
        if (context instanceof ClientSideContext) {
            return ConcreteContext.runWithContext(context, callable);
        }
        try {
            return CONTEXT.call((Object)context, () -> {
                ServiceMethodInvocation invocation = new ServiceMethodInvocation(method, params){

                    @Override
                    public Class<?> getInterfaceClass() {
                        return interfaceClass;
                    }

                    public Object proceed() throws Throwable {
                        return callable.call();
                    }

                    public Object getThis() {
                        return BeanServiceLoaderProvider.getBeanProvider().getBean(interfaceClass);
                    }
                };
                return ((SyncInterceptorChain)interceptorChainSingleton.get()).invoke(invocation);
            });
        }
        catch (Throwable throwable) {
            throw ConcreteHelper.getException(throwable);
        }
    }

    private static abstract class ServiceMethodInvocation
    implements ConcreteMethodInvocation {
        private final Object[] arguments;
        private final Method method;

        private ServiceMethodInvocation(Method method, Object[] arguments) {
            this.arguments = arguments;
            this.method = method;
        }

        public Method getMethod() {
            return this.method;
        }

        public Object[] getArguments() {
            return this.arguments;
        }

        public AccessibleObject getStaticPart() {
            return null;
        }
    }
}

