/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.common;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.regex.Pattern;
import org.coodex.concrete.api.ConcreteService;
import org.coodex.concrete.api.Priority;
import org.coodex.concrete.common.AbstractErrorCodes;
import org.coodex.concrete.common.ConcreteClassFilter;
import org.coodex.concrete.common.ConcreteException;
import org.coodex.concrete.common.DefinitionContext;
import org.coodex.concrete.common.DefinitionContextImpl;
import org.coodex.concrete.common.ErrorMessageFacade;
import org.coodex.concrete.common.IF;
import org.coodex.concrete.common.Subjoin;
import org.coodex.concrete.common.modules.AbstractModule;
import org.coodex.concrete.common.modules.AbstractUnit;
import org.coodex.concurrent.ExecutorsHelper;
import org.coodex.config.Config;
import org.coodex.util.ClassNameFilter;
import org.coodex.util.Common;
import org.coodex.util.ReflectHelper;
import org.coodex.util.SingletonMap;

public class ConcreteHelper {
    public static final String VERSION = "0.4.0-SNAPSHOT";
    public static final String TAG_CLIENT = "client";
    public static final String KEY_LOCATION = "location";
    public static final String TOKEN_KEY = "CONCRETE-TOKEN-ID";
    public static final String AGENT_KEY = "user-agent";
    public static final String LOCALE_KEY = "locale";
    public static final Integer DEFAULT_MAX_QUEUE_SIZE = 8844;
    private static final Integer DEFAULT_CORE_POOL_SIZE = Runtime.getRuntime().availableProcessors() * 2;
    private static final Integer DEFAULT_MAX_POOL_SIZE = Runtime.getRuntime().availableProcessors() * 4;
    private static SingletonMap<String, ScheduledExecutorService> scheduledExecutorMap = new SingletonMap((SingletonMap.Builder)new SingletonMap.Builder<String, ScheduledExecutorService>(){

        public ScheduledExecutorService build(String key) {
            String aliasTo = Config.get((String)"scheduler", (String[])new String[]{key, ConcreteHelper.getAppSet()});
            if (Common.isBlank((String)aliasTo)) {
                return ExecutorsHelper.newScheduledThreadPool((int)((Integer)Config.getValue((String)"scheduler.executorSize", (Object)1, (String[])new String[]{key, ConcreteHelper.getAppSet()})), (String)(key + ".scheduler"));
            }
            return (ScheduledExecutorService)scheduledExecutorMap.get((Object)aliasTo);
        }
    });
    private static SingletonMap<String, ExecutorService> executorServiceMap = new SingletonMap((SingletonMap.Builder)new SingletonMap.Builder<String, ExecutorService>(){

        public ExecutorService build(String key) {
            String aliasTo = Config.get((String)"executor", (String[])new String[]{key, ConcreteHelper.getAppSet()});
            if (Common.isBlank((String)aliasTo)) {
                return ExecutorsHelper.newPriorityThreadPool((int)((Integer)Config.getValue((String)"executor.corePoolSize", (Object)DEFAULT_CORE_POOL_SIZE, (String[])new String[]{key, ConcreteHelper.getAppSet()})), (int)((Integer)Config.getValue((String)"executor.maximumPoolSize", (Object)DEFAULT_MAX_POOL_SIZE, (String[])new String[]{key, ConcreteHelper.getAppSet()})), (int)((Integer)Config.getValue((String)"executor.maxQueueSize", (Object)DEFAULT_MAX_QUEUE_SIZE, (String[])new String[]{key, ConcreteHelper.getAppSet()})), (long)((Long)Config.getValue((String)"executor.keepAliveTime", (Object)60L, (String[])new String[]{key, ConcreteHelper.getAppSet()})), (String)(key + ".executor"));
            }
            return (ExecutorService)executorServiceMap.get((Object)aliasTo);
        }
    });

    public static Integer getTokenMaxIdleInMinute() {
        return (Integer)Config.getValue((String)"token.maxIdleTime", (Object)60, (String[])new String[]{ConcreteHelper.getAppSet()});
    }

    public static Map<String, String> updatedMap(Subjoin subjoin) {
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        if (subjoin != null && subjoin.updatedKeySet().size() > 0) {
            for (String key : subjoin.updatedKeySet()) {
                map.put(key, subjoin.get(key));
            }
        }
        return map;
    }

    public static String getString(String tag, String module, String key) {
        return Config.get((String)key, (String[])new String[]{tag, module});
    }

    public static ExecutorService getExecutor() {
        return ConcreteHelper.getExecutor("service");
    }

    public static ScheduledExecutorService getScheduler() {
        return ConcreteHelper.getScheduler("service");
    }

    public static ScheduledExecutorService getScheduler(String name) {
        return (ScheduledExecutorService)scheduledExecutorMap.get((Object)name);
    }

    public static ExecutorService getExecutor(String executorName) {
        return (ExecutorService)executorServiceMap.get((Object)executorName);
    }

    public static String getServiceName(Class<?> clz) {
        if (clz == null) {
            return null;
        }
        ConcreteService concreteService = clz.getAnnotation(ConcreteService.class);
        if (concreteService == null) {
            return null;
        }
        return Common.isBlank((String)concreteService.value()) ? (concreteService.nonspecific() ? "" : clz.getCanonicalName()) : Common.trim((String)concreteService.value(), (String)"/\\.");
    }

    public static void foreachClassInPackages(ReflectHelper.Processor processor, String ... packages) {
        String[] packageParrterns = packages;
        if (packageParrterns == null || packageParrterns.length == 0) {
            packageParrterns = ConcreteHelper.getApiPackages();
        }
        if (packageParrterns == null) {
            packageParrterns = new String[]{};
        }
        ReflectHelper.foreachClass(clazz -> {
            if (AbstractErrorCodes.class.isAssignableFrom(clazz)) {
                ErrorMessageFacade.register(clazz);
            }
            processor.process(clazz);
        }, (ClassNameFilter)new ConcreteClassFilter(){

            @Override
            protected boolean accept(Class<?> clazz) {
                return ConcreteHelper.isConcreteService(clazz) || AbstractErrorCodes.class.isAssignableFrom(clazz);
            }
        }, (String[])packageParrterns);
    }

    private static String[] toPackages(String[] patterns) {
        String[] result = new String[patterns.length];
        int l = patterns.length;
        for (int i = 0; i < l; ++i) {
            result[i] = ConcreteHelper.toPackage(patterns[i]);
        }
        return result;
    }

    private static String toPackage(String parttern) {
        int i = parttern.indexOf(42);
        return Common.trim((String)(i > 0 ? parttern.substring(0, i) : parttern), (char[])new char[]{'.'});
    }

    private static boolean isMatch(Class<?> clazz, String ... packagePartterns) {
        String className = clazz.getName();
        for (String s : packagePartterns) {
            if (!(s.indexOf(42) > 0 ? Pattern.compile("^" + s.replaceAll("\\.", "\\\\.").replaceAll("\\*\\*", ".+").replaceAll("\\*", "[\\\\w]+")).matcher(className).find() : className.startsWith(s))) continue;
            return true;
        }
        return false;
    }

    public static boolean isAbstract(Class<?> clz) {
        ConcreteService service = clz.getAnnotation(ConcreteService.class);
        return service != null && service.nonspecific();
    }

    public static boolean isConcreteService(Method method) {
        ConcreteService service = method.getAnnotation(ConcreteService.class);
        return service == null || !service.notService();
    }

    public static boolean isConcreteService(Class<?> clz) {
        return clz != null && clz.isInterface() && clz.getAnnotation(ConcreteService.class) != null && !ConcreteHelper.isAbstract(clz);
    }

    public static int getPriority(Method method, Class<?> clz) {
        Priority priority = (Priority)ConcreteHelper.getContext(method, clz).getAnnotation(Priority.class);
        return priority == null ? 5 : Math.max(1, Math.min(10, priority.value()));
    }

    public static int getPriority(AbstractUnit unit) {
        return ConcreteHelper.getPriority(unit.getMethod(), ((AbstractModule)unit.getDeclaringModule()).getInterfaceClass());
    }

    public static DefinitionContext getContext(Method method, Class<?> clz) throws ConcreteException {
        return IF.isNull(ConcreteHelper.getContext(method, clz, new Stack()), 1001, new Object[0]);
    }

    private static boolean isRoot(Class clz) {
        if (clz == null) {
            return true;
        }
        String className = clz.getName();
        return className.startsWith("java.") || className.startsWith("javax.");
    }

    private static DefinitionContext getContext(Method method, Class<?> clz, Stack<Class<?>> stack) {
        if (ConcreteHelper.isRoot(clz)) {
            return null;
        }
        if (stack.contains(clz)) {
            return null;
        }
        stack.add(clz);
        if (ConcreteHelper.isConcreteService(clz)) {
            DefinitionContextImpl context = new DefinitionContextImpl();
            context.setDeclaringClass(clz);
            Method unitMethod = ConcreteHelper.findMethod(method, clz);
            if (unitMethod == null) {
                return null;
            }
            context.setDeclaringMethod(unitMethod);
            return context;
        }
        for (Class<?> clazz : clz.getInterfaces()) {
            DefinitionContext context = ConcreteHelper.getContext(method, clazz, stack);
            if (context == null) continue;
            return context;
        }
        return ConcreteHelper.getContext(method, clz.getSuperclass(), stack);
    }

    private static Method findMethod(Method method, Class<?> clz) {
        return ConcreteHelper.findMethod(method, clz, new Stack());
    }

    private static Method findMethod(Method method, Class<?> clz, Collection<Class<?>> stack) {
        if (stack.contains(clz)) {
            return null;
        }
        stack.add(clz);
        try {
            return clz.getDeclaredMethod(method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            for (Class<?> clazz : clz.getInterfaces()) {
                Method m = ConcreteHelper.findMethod(method, clazz, stack);
                if (m == null) continue;
                return m;
            }
            return null;
        }
    }

    public static ConcreteException findException(Throwable th) {
        if (th == null) {
            return null;
        }
        for (Throwable t = th; t != null; t = t.getCause()) {
            if (!(t instanceof ConcreteException)) continue;
            return (ConcreteException)t;
        }
        return null;
    }

    public static ConcreteException getException(Throwable th) {
        ConcreteException concreteException = ConcreteHelper.findException(th);
        if (concreteException == null) {
            concreteException = new ConcreteException(99999, th.getLocalizedMessage(), th);
        }
        return concreteException;
    }

    public static List<Class> inheritedChain(Class root, Class sub) {
        if (root == null || root.getAnnotation(ConcreteService.class) == null) {
            return null;
        }
        if (root.equals(sub)) {
            return Collections.emptyList();
        }
        for (Class<?> c : sub.getInterfaces()) {
            List<Class> subChain;
            if (!root.isAssignableFrom(c) || (subChain = ConcreteHelper.inheritedChain(root, c)) == null) continue;
            ArrayList<Class> inheritedChain = new ArrayList<Class>();
            inheritedChain.add(c);
            inheritedChain.addAll(subChain);
            return inheritedChain;
        }
        return null;
    }

    public static DefinitionContext getDefinitionContext(Class<?> cls, Method method) {
        DefinitionContextImpl definitionContext = new DefinitionContextImpl();
        definitionContext.setDeclaringClass(cls);
        definitionContext.setDeclaringMethod(method);
        return definitionContext;
    }

    public static String[] getApiPackages(String namespace) {
        String[] packages = Config.getArray((String)"api.packages", (String)",", (String[])new String[0], (String[])new String[]{"concrete", namespace, ConcreteHelper.getAppSet()});
        return packages.length == 0 ? ConcreteHelper.getApiPackages() : packages;
    }

    public static String[] getApiPackages() {
        return Config.getArray((String)"api.packages", (String)",", (String[])new String[0], (String[])new String[]{"concrete", ConcreteHelper.getAppSet()});
    }

    public static String getAppSet() {
        return System.getProperty("concrete.appSet");
    }

    public static String devModelKey(String module) {
        return "org.coodex.concrete" + (Common.isBlank((String)module) ? "" : "." + module) + ".devMode";
    }

    public static boolean isDevModel(String module) {
        return System.getProperty(ConcreteHelper.devModelKey(module)) != null || System.getProperty(ConcreteHelper.devModelKey(null)) != null;
    }
}

