/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.common;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.coodex.concrete.api.ErrorMsg;
import org.coodex.concrete.common.AbstractErrorCodes;
import org.coodex.concrete.common.AbstractMessageFacade;
import org.coodex.concrete.common.ConcreteContext;
import org.coodex.concrete.common.ErrorDefinition;
import org.coodex.concrete.common.MessageFormatter;
import org.coodex.concrete.common.ServerSideContext;
import org.coodex.util.Common;
import org.coodex.util.I18N;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorMessageFacade
extends AbstractMessageFacade {
    private static final Logger log = LoggerFactory.getLogger(ErrorMessageFacade.class);
    private static final Set<Class<? extends AbstractErrorCodes>> REGISTERED = new HashSet<Class<? extends AbstractErrorCodes>>();
    private static final Map<Integer, Field> errorCodes = new HashMap<Integer, Field>();

    private ErrorMessageFacade() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerClass(Class<? extends AbstractErrorCodes> clz) {
        if (clz == null) {
            return;
        }
        if (REGISTERED.contains(clz)) {
            return;
        }
        Map<Integer, Field> map = errorCodes;
        synchronized (map) {
            for (Field f : clz.getDeclaredFields()) {
                if (!Integer.TYPE.equals(f.getType()) || !Modifier.isStatic(f.getModifiers()) || !Modifier.isPublic(f.getModifiers())) continue;
                f.setAccessible(true);
                try {
                    int code = f.getInt(null);
                    if (errorCodes.containsKey(code)) {
                        Field field = errorCodes.get(code);
                        if (field.equals(f)) continue;
                        log.warn("errorCode duplicate {}.{} and {}.{}", new Object[]{field.getDeclaringClass().getCanonicalName(), field.getName(), f.getDeclaringClass().getCanonicalName(), f.getName()});
                        continue;
                    }
                    errorCodes.put(code, f);
                }
                catch (IllegalAccessException e) {
                    log.warn("Cannot bind errorCode: {}.{}", (Object)f.getDeclaringClass().getCanonicalName(), (Object)f.getName());
                }
            }
        }
        REGISTERED.add(clz);
    }

    public static void register(Class<? extends AbstractErrorCodes> ... classes) {
        for (Class<? extends AbstractErrorCodes> clz : classes) {
            ErrorMessageFacade.registerClass(clz);
        }
    }

    public static Set<Integer> allRegisteredErrorCodes() {
        return errorCodes.keySet();
    }

    public static String getMessageTemplate(int code) {
        return ErrorMessageFacade.getMessageOrPattern(false, code, new Object[0]);
    }

    public static String getMessage(int code, Object ... objects) {
        return ErrorMessageFacade.getMessageOrPattern(true, code, objects);
    }

    private static String getMessageOrPattern(boolean format, int code, Object ... objects) {
        Field f = errorCodes.get(code);
        ErrorMsg errorMsg = null;
        ErrorMsg formatterValue = null;
        if (f == null) {
            if (ConcreteContext.getServiceContext() instanceof ServerSideContext) {
                log.debug("errorCode [{}] has not register.", (Object)code);
            }
        } else {
            errorMsg = f.getAnnotation(ErrorMsg.class);
            formatterValue = errorMsg == null ? f.getDeclaringClass().getAnnotation(ErrorMsg.class) : errorMsg;
        }
        MessageFormatter formatter = ErrorMessageFacade.getFormatter(formatterValue == null ? null : formatterValue.formatterClass());
        AbstractErrorCodes.Namespace namespace = f == null ? null : f.getDeclaringClass().getAnnotation(AbstractErrorCodes.Namespace.class);
        String errorMessageNamespace = namespace == null ? "message" : namespace.value();
        String string = errorMessageNamespace = Common.isBlank((String)errorMessageNamespace) ? f.getDeclaringClass().getName() : errorMessageNamespace;
        String msgTemp = errorMsg == null || Common.isBlank((String)errorMsg.value().trim()) ? "{" + (formatter.getNamespace() == null ? "" : formatter.getNamespace() + ".") + errorMessageNamespace + "." + code + "}" : errorMsg.value();
        String pattern = I18N.translate((String)msgTemp);
        return pattern != null ? (format ? formatter.format(pattern, objects) : pattern) : null;
    }

    private static Object[] actualObjects(Object[] objects) {
        if (objects == null || objects.length == 0) {
            return objects;
        }
        Object[] objectArray = new Object[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            objectArray[i] = objects[i] instanceof Supplier ? ((Supplier)objects[i]).get() : objects[i];
        }
        return objectArray;
    }

    public static List<ErrorDefinition> getAllErrorInfo() {
        ArrayList<ErrorDefinition> errorDefinitions = new ArrayList<ErrorDefinition>();
        for (Integer i : ErrorMessageFacade.allRegisteredErrorCodes()) {
            errorDefinitions.add(new ErrorDefinition(i));
        }
        Collections.sort(errorDefinitions);
        return errorDefinitions;
    }
}

