/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.common.bytecode.javassist;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ConstPool;
import javassist.bytecode.SignatureAttribute;
import javassist.bytecode.annotation.Annotation;
import org.coodex.util.Singleton;
import org.coodex.util.SingletonMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavassistHelper {
    private static final Logger log = LoggerFactory.getLogger(JavassistHelper.class);
    public static final Singleton<Boolean> IS_JAVA_9_AND_LAST = new Singleton(() -> {
        try {
            Class.class.getMethod("getModule", new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    });
    private static final SingletonMap<ClassLoader, ClassPool> classPools = new SingletonMap(key -> {
        ClassPool classPool = new ClassPool(true);
        classPool.appendClassPath((ClassPath)new LoaderClassPath(key));
        return classPool;
    });

    public static ClassPool getClassPool(Class clz) {
        return clz == null ? ClassPool.getDefault() : (ClassPool)classPools.get((Object)clz.getClassLoader());
    }

    public static SignatureAttribute.ClassType classType(String className, String ... arguments) {
        ArrayList<SignatureAttribute.TypeArgument> args = new ArrayList<SignatureAttribute.TypeArgument>();
        for (String arg : arguments) {
            args.add(new SignatureAttribute.TypeArgument((SignatureAttribute.ObjectType)new SignatureAttribute.ClassType(arg)));
        }
        return new SignatureAttribute.ClassType(className, args.toArray(new SignatureAttribute.TypeArgument[0]));
    }

    public static SignatureAttribute.ClassType classType(String className, Type ... arguments) {
        ArrayList<SignatureAttribute.TypeArgument> args = new ArrayList<SignatureAttribute.TypeArgument>();
        for (Type arg : arguments) {
            args.add(new SignatureAttribute.TypeArgument((SignatureAttribute.ObjectType)JavassistHelper.classType(arg, null)));
        }
        return new SignatureAttribute.ClassType(className, args.toArray(new SignatureAttribute.TypeArgument[0]));
    }

    public static String getTypeName(Class<?> c) {
        return c.getName();
    }

    public static String getSignature(SignatureAttribute.Type type) {
        if (type instanceof SignatureAttribute.ObjectType) {
            return ((SignatureAttribute.ObjectType)type).encode();
        }
        if (type instanceof SignatureAttribute.BaseType) {
            return String.valueOf(((SignatureAttribute.BaseType)type).getDescriptor());
        }
        return null;
    }

    public static SignatureAttribute.Type classType(Type t, Class<?> contextClass) {
        if (t instanceof Class) {
            Class<?> c = (Class<?>)t;
            if (c.isArray()) {
                int dim = 0;
                while (c.isArray()) {
                    ++dim;
                    c = c.getComponentType();
                }
                return new SignatureAttribute.ArrayType(dim, (SignatureAttribute.Type)(c.isPrimitive() ? new SignatureAttribute.BaseType(JavassistHelper.getTypeName(c)) : new SignatureAttribute.ClassType(JavassistHelper.getTypeName(c))));
            }
            if (c.isPrimitive()) {
                return new SignatureAttribute.BaseType(c.getName());
            }
            return new SignatureAttribute.ClassType(JavassistHelper.getTypeName(c));
        }
        if (t instanceof ParameterizedType) {
            Type[] types = ((ParameterizedType)t).getActualTypeArguments();
            ArrayList<SignatureAttribute.TypeArgument> args = new ArrayList<SignatureAttribute.TypeArgument>();
            for (Type type : types) {
                args.add(new SignatureAttribute.TypeArgument((SignatureAttribute.ObjectType)JavassistHelper.classType(type, contextClass)));
            }
            return new SignatureAttribute.ClassType(((Class)((ParameterizedType)t).getRawType()).getName(), args.toArray(new SignatureAttribute.TypeArgument[0]));
        }
        if (t instanceof TypeVariable) {
            Type ttt = JavassistHelper.find(contextClass, (TypeVariable)t);
            if (ttt == null) {
                log.warn("WARN!! UnsupportedType: {}", (Object)t);
                return null;
            }
            return JavassistHelper.classType(ttt, contextClass);
        }
        log.warn("WARN!! UnsupportedType: {}", (Object)t);
        return null;
    }

    private static Type find(Class<?> contextClass, TypeVariable<Class<?>> t) {
        Type[] supers;
        Class<?> clz = t.getGenericDeclaration();
        for (Type $ : supers = contextClass.getGenericInterfaces()) {
            ParameterizedType pt;
            Class rawType;
            if ($ instanceof Class) {
                if (!clz.isAssignableFrom((Class)$)) continue;
                return JavassistHelper.find((Class)$, t);
            }
            if (!($ instanceof ParameterizedType) || !clz.isAssignableFrom(rawType = (Class)(pt = (ParameterizedType)$).getRawType())) continue;
            Type tt = JavassistHelper.find(rawType, t);
            if (tt == null) {
                return pt.getActualTypeArguments()[JavassistHelper.indexOf(t)];
            }
            return tt;
        }
        return null;
    }

    private static int indexOf(TypeVariable<Class<?>> t) {
        TypeVariable<Class<?>>[] params = t.getGenericDeclaration().getTypeParameters();
        for (int i = 0; i < params.length; ++i) {
            if (params[i] != t) continue;
            return i;
        }
        return -1;
    }

    public static AnnotationsAttribute aggregate(ConstPool cp, Annotation ... anno) {
        AnnotationsAttribute attr = new AnnotationsAttribute(cp, "RuntimeVisibleAnnotations");
        for (Annotation annotation : anno) {
            if (annotation == null) continue;
            attr.addAnnotation(annotation);
        }
        return attr;
    }

    public static CtClass[] toCtClass(Class<?>[] classes, ClassPool classPool) {
        if (classes == null || classes.length == 0) {
            return new CtClass[0];
        }
        CtClass[] ctClasses = new CtClass[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            ctClasses[i] = classPool.getOrNull(classes[i].getName());
        }
        return ctClasses;
    }
}

