/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.common.modules;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.coodex.concrete.api.Description;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.modules.AbstractUnit;
import org.coodex.concrete.common.modules.Annotated;

public abstract class AbstractModule<UNIT extends AbstractUnit>
implements Annotated,
Comparable<AbstractModule> {
    private Class<?> interfaceClass;
    private List<UNIT> units = new ArrayList<UNIT>();

    public AbstractModule(Class<?> interfaceClass) {
        if (!ConcreteHelper.isConcreteService(interfaceClass)) {
            throw new RuntimeException(interfaceClass.getName() + " is NOT a concrete ConcreteService");
        }
        this.interfaceClass = interfaceClass;
        for (Method method : interfaceClass.getMethods()) {
            UNIT unit;
            if (Object.class.equals(method.getDeclaringClass()) || !ConcreteHelper.isConcreteService(method) || (unit = this.buildUnit(method)) == null) continue;
            this.units.add(unit);
        }
    }

    public Class<?> getInterfaceClass() {
        return this.interfaceClass;
    }

    private Description getDesc() {
        return this.getDeclaredAnnotation(Description.class);
    }

    public abstract String getName();

    public String getLabel() {
        return this.getDesc() == null ? this.getName() : this.getDesc().name();
    }

    public String getDescription() {
        return this.getDesc() == null ? null : this.getDesc().description();
    }

    public final UNIT[] getUnits() {
        return this.toArrays(this.units);
    }

    protected abstract UNIT[] toArrays(List<UNIT> var1);

    protected abstract UNIT buildUnit(Method var1);

    @Override
    public <T extends Annotation> T getDeclaredAnnotation(Class<T> annotationClass) {
        return this.interfaceClass.getAnnotation(annotationClass);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.getDeclaredAnnotation(annotationClass);
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.interfaceClass.getAnnotations();
    }
}

