/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.common.modules;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.coodex.concrete.api.AccessAllow;
import org.coodex.concrete.api.Description;
import org.coodex.concrete.api.Signable;
import org.coodex.concrete.common.DefinitionContext;
import org.coodex.concrete.common.modules.AbstractModule;
import org.coodex.concrete.common.modules.AbstractParam;
import org.coodex.concrete.common.modules.Annotated;

public abstract class AbstractUnit<PARAM extends AbstractParam, MODULE extends AbstractModule>
implements Annotated,
Comparable<AbstractUnit> {
    private final boolean deprecated;
    private Method method;
    private MODULE declaringModule;
    private DefinitionContext context;
    private List<PARAM> params = new ArrayList<PARAM>();

    public AbstractUnit(Method method, MODULE module) {
        this.method = method;
        this.declaringModule = module;
        this.deprecated = method.getAnnotation(Deprecated.class) != null;
        int j = method.getParameterTypes().length;
        for (int i = 0; i < j; ++i) {
            this.params.add(this.buildParam(method, i));
        }
        this.afterInit();
    }

    protected void afterInit() {
    }

    public MODULE getDeclaringModule() {
        return this.declaringModule;
    }

    public Method getMethod() {
        return this.method;
    }

    private Description getDesc() {
        return this.getDeclaredAnnotation(Description.class);
    }

    public abstract String getName();

    protected abstract PARAM buildParam(Method var1, int var2);

    public String getLabel() {
        return this.getDesc() == null ? this.getName() : this.getDesc().name();
    }

    public String getDescription() {
        return this.getDesc() == null ? null : this.getDesc().description();
    }

    public String getFunctionName() {
        return this.method.getName();
    }

    public abstract String getInvokeType();

    public Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    public Type getGenericReturnType() {
        return this.method.getGenericReturnType();
    }

    public AccessAllow getAccessAllow() {
        return (AccessAllow)this.getContext().getAnnotation(AccessAllow.class);
    }

    public Signable getSignable() {
        return (Signable)this.getContext().getAnnotation(Signable.class);
    }

    @Override
    public <T extends Annotation> T getDeclaredAnnotation(Class<T> annotationClass) {
        return this.method.getAnnotation(annotationClass);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        T annotation = this.getDeclaredAnnotation(annotationClass);
        return annotation == null ? ((AbstractModule)this.declaringModule).getAnnotation(annotationClass) : annotation;
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.method.getAnnotations();
    }

    public final PARAM[] getParameters() {
        return this.toArrays(this.params);
    }

    protected abstract PARAM[] toArrays(List<PARAM> var1);

    public synchronized DefinitionContext getContext() {
        if (this.context == null) {
            this.context = this.toContext();
        }
        return this.context;
    }

    protected abstract DefinitionContext toContext();

    public boolean isDeprecated() {
        return this.deprecated;
    }
}

