/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.intercept;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.aopalliance.intercept.MethodInvocation;
import org.coodex.concrete.common.DefinitionContext;
import org.coodex.concrete.core.intercept.AbstractInterceptor;
import org.coodex.concrete.core.intercept.ConcreteInterceptor;
import org.coodex.concrete.core.intercept.InterceptorChain;

public class AsyncInterceptorChain
extends AbstractInterceptor
implements Set<ConcreteInterceptor>,
InterceptorChain {
    private static Comparator<ConcreteInterceptor> comparatorAsc = new MyComparator(1);
    private static Comparator<ConcreteInterceptor> comparatorDesc = new MyComparator(-1);
    private Set<ConcreteInterceptor> interceptors = new HashSet<ConcreteInterceptor>();

    public AsyncInterceptorChain() {
    }

    public AsyncInterceptorChain(List<ConcreteInterceptor> interceptors) {
        this.interceptors.addAll(interceptors);
    }

    @Override
    protected boolean accept_(DefinitionContext context) {
        return true;
    }

    @Override
    public int getOrder() {
        return -1;
    }

    @Override
    public void before(DefinitionContext context, MethodInvocation joinPoint) {
        ConcreteInterceptor[] interceptors = this.interceptors.toArray(new ConcreteInterceptor[0]);
        Arrays.sort(interceptors, comparatorAsc);
        for (ConcreteInterceptor interceptor : interceptors) {
            if (!interceptor.accept(context)) continue;
            interceptor.before(context, joinPoint);
        }
    }

    @Override
    public Object after(DefinitionContext context, MethodInvocation joinPoint, Object result) {
        ConcreteInterceptor[] interceptors = this.interceptors.toArray(new ConcreteInterceptor[0]);
        Arrays.sort(interceptors, comparatorDesc);
        for (ConcreteInterceptor interceptor : interceptors) {
            if (!interceptor.accept(context)) continue;
            result = interceptor.after(context, joinPoint, result);
        }
        return result;
    }

    @Override
    public Throwable onError(DefinitionContext context, MethodInvocation joinPoint, Throwable th) {
        ConcreteInterceptor[] interceptors = this.interceptors.toArray(new ConcreteInterceptor[0]);
        Arrays.sort(interceptors, comparatorDesc);
        for (ConcreteInterceptor interceptor : interceptors) {
            if (!interceptor.accept(context) || (th = interceptor.onError(context, joinPoint, th)) != null) continue;
            return null;
        }
        return th;
    }

    @Override
    public int size() {
        return this.interceptors.size();
    }

    @Override
    public boolean isEmpty() {
        return this.interceptors.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.interceptors.contains(o);
    }

    @Override
    public Iterator<ConcreteInterceptor> iterator() {
        return this.interceptors.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.interceptors.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.interceptors.toArray(a);
    }

    @Override
    public boolean add(ConcreteInterceptor concreteInterceptor) {
        return this.interceptors.add(concreteInterceptor);
    }

    @Override
    public boolean remove(Object o) {
        return this.interceptors.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.interceptors.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends ConcreteInterceptor> c) {
        return this.interceptors.addAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.interceptors.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.interceptors.removeAll(c);
    }

    @Override
    public void clear() {
        this.interceptors.clear();
    }

    private static class MyComparator
    implements Comparator<ConcreteInterceptor> {
        private final int sign;

        public MyComparator(int sign) {
            this.sign = sign;
        }

        public int $compare(ConcreteInterceptor o1, ConcreteInterceptor o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.getOrder() - o2.getOrder();
        }

        @Override
        public int compare(ConcreteInterceptor o1, ConcreteInterceptor o2) {
            return this.$compare(o1, o2) * this.sign;
        }
    }
}

