/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.intercept;

import java.util.HashMap;
import org.aopalliance.intercept.MethodInvocation;
import org.coodex.concrete.api.LogAtomic;
import org.coodex.concrete.api.OperationLog;
import org.coodex.concrete.common.AbstractMessageFacade;
import org.coodex.concrete.common.Account;
import org.coodex.concrete.common.AccountID;
import org.coodex.concrete.common.ConcreteContext;
import org.coodex.concrete.common.DefinitionContext;
import org.coodex.concrete.common.LogFormatter;
import org.coodex.concrete.common.NamedAccount;
import org.coodex.concrete.common.OperationLogger;
import org.coodex.concrete.core.intercept.AbstractSyncInterceptor;
import org.coodex.concrete.core.intercept.annotations.Local;
import org.coodex.concrete.core.intercept.annotations.ServerSide;
import org.coodex.concrete.core.intercept.annotations.TestContext;
import org.coodex.concrete.core.token.TokenWrapper;
import org.coodex.util.Common;
import org.coodex.util.I18N;
import org.coodex.util.ServiceLoader;
import org.coodex.util.ServiceLoaderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServerSide
@TestContext
@Local
public class OperationLogInterceptor
extends AbstractSyncInterceptor {
    private static final Logger log = LoggerFactory.getLogger(OperationLogInterceptor.class);
    private static final ServiceLoader<OperationLogger> LOGGER_SERVICE_LOADER = new ServiceLoaderImpl<OperationLogger>((accountId, accountName, category, subClass, message) -> log.info("accountId: {}; accountName: {}; category: {}; subClass: {}; message: {}", new Object[]{accountId, accountName, category, subClass, message})){};
    static ThreadLocal<Account<? extends AccountID>> OPERATOR = new ThreadLocal();

    private static String buildLog(String category, String subClass, String messageTemplate, Class<? extends LogFormatter> formatterClass) {
        return AbstractMessageFacade.getLogFormatter(formatterClass).format(Common.isBlank((String)messageTemplate) ? I18N.translate((String)OperationLogInterceptor.getMessageKey(category, subClass)) : I18N.translate((String)messageTemplate), ConcreteContext.getLoggingData());
    }

    private static String getMessageKey(String category, String subClass) {
        if (Common.isBlank((String)category) && Common.isBlank((String)subClass)) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        if (!Common.isBlank((String)category)) {
            builder.append(category);
        }
        if (!Common.isBlank((String)subClass)) {
            if (builder.length() > 0) {
                builder.append('.');
            }
            builder.append(subClass);
        }
        return builder.toString();
    }

    private static OperationLogger getLogger(Class<? extends OperationLogger> loggerClass) {
        return loggerClass == null || loggerClass == OperationLogger.class ? (OperationLogger)LOGGER_SERVICE_LOADER.get() : (OperationLogger)LOGGER_SERVICE_LOADER.get(loggerClass);
    }

    @Override
    public int getOrder() {
        return 2000;
    }

    @Override
    protected boolean accept_(DefinitionContext context) {
        return context.getAnnotation(OperationLog.class) != null || context.getAnnotation(LogAtomic.class) != null;
    }

    private Account getOperator() {
        try {
            Account account = TokenWrapper.getInstance().currentAccount();
            return account;
        }
        catch (Throwable th) {
            Account<? extends AccountID> account = OPERATOR.get();
            return account;
        }
        finally {
            OPERATOR.remove();
        }
    }

    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
        return ConcreteContext.LOGGING.call(new HashMap(), () -> super.invoke(invocation));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object after(DefinitionContext context, MethodInvocation joinPoint, Object result) {
        try {
            LogAtomic logAtomic;
            String accountName;
            Account account = this.getOperator();
            String accountId = account == null ? null : (account.getId() instanceof AccountID ? ((AccountID)account.getId()).serialize() : account.getId().toString());
            String string = accountName = account == null ? "Anonymous" : null;
            if (account != null) {
                accountName = account instanceof NamedAccount ? ((NamedAccount)account).getName() : "Unknown";
            }
            String category = null;
            String subClass = null;
            String messageTemplate = null;
            LogAtomic.LoggingType loggingType = LogAtomic.LoggingType.DATA;
            Class formatterClass = LogFormatter.class;
            Class loggerClass = OperationLogger.class;
            OperationLog operationLog = (OperationLog)context.getAnnotation(OperationLog.class);
            if (operationLog != null) {
                category = operationLog.category();
                formatterClass = operationLog.formatterClass();
                loggerClass = operationLog.loggerClass();
            }
            if ((logAtomic = (LogAtomic)context.getAnnotation(LogAtomic.class)) != null) {
                if (!Common.isBlank((String)logAtomic.category())) {
                    category = logAtomic.category();
                }
                subClass = logAtomic.subClass();
                loggingType = logAtomic.loggingType();
                messageTemplate = logAtomic.message();
            }
            if (Common.isBlank(subClass)) {
                subClass = context.getDeclaringMethod().getName();
            }
            if (this.isDoLog(loggingType)) {
                OperationLogInterceptor.getLogger(loggerClass).log(accountId, accountName, category, subClass, OperationLogInterceptor.buildLog(category, subClass, messageTemplate, formatterClass));
            }
        }
        catch (Throwable th) {
            log.warn("{}", (Object)th.getLocalizedMessage(), (Object)th);
        }
        return super.after(context, joinPoint, result);
    }

    private boolean isDoLog(LogAtomic.LoggingType loggingType) {
        boolean doLog = false;
        switch (loggingType) {
            case NO: {
                break;
            }
            case DATA: {
                doLog = ConcreteContext.getLoggingData().size() > 0;
                break;
            }
            case ALWAYS: {
                doLog = true;
            }
        }
        return doLog;
    }
}

