/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.intercept;

import java.util.Calendar;
import java.util.List;
import org.aopalliance.intercept.MethodInvocation;
import org.coodex.concrete.api.Modules;
import org.coodex.concrete.common.Account;
import org.coodex.concrete.common.ConcreteException;
import org.coodex.concrete.common.DefinitionContext;
import org.coodex.concrete.common.Production;
import org.coodex.concrete.common.ProductionRepository;
import org.coodex.concrete.common.SubjoinWrapper;
import org.coodex.concrete.common.Token;
import org.coodex.concrete.common.Warning;
import org.coodex.concrete.common.WarningData;
import org.coodex.concrete.core.intercept.AbstractSyncInterceptor;
import org.coodex.concrete.core.intercept.annotations.ServerSide;
import org.coodex.concrete.core.token.TokenWrapper;
import org.coodex.util.AcceptableServiceLoader;
import org.coodex.util.Clock;
import org.coodex.util.Common;

@ServerSide
public class ProductionValidationInterceptor
extends AbstractSyncInterceptor {
    private Token token = TokenWrapper.getInstance();
    private AcceptableServiceLoader<Account, ProductionRepository> productionRepositoryAcceptableServiceLoader = new AcceptableServiceLoader<Account, ProductionRepository>(){};

    @Override
    protected boolean accept_(DefinitionContext context) {
        return context.getAnnotation(Modules.NonFunctional.class) == null && context.getAnnotation(Modules.class) != null;
    }

    @Override
    public int getOrder() {
        return 103;
    }

    @Override
    public Object around(DefinitionContext context, MethodInvocation joinPoint) throws Throwable {
        Account account = this.token.currentAccount();
        if (account != null) {
            this.productionCheck(context, account);
        }
        try {
            Object result = super.around(context, joinPoint);
            if (account == null && (account = this.token.currentAccount()) != null) {
                this.productionCheck(context, account);
            }
            return result;
        }
        catch (ConcreteException ce) {
            if (ce.getCode() == 1101 || ce.getCode() == 1103) {
                this.token.invalidate();
            }
            throw ce;
        }
    }

    private Production findIn(List<Production> productions, String[] modules) {
        Production result = null;
        for (Production production : productions) {
            if (production.getModules() == null || production.getModules().size() <= 0) continue;
            for (String module : modules) {
                if (!production.getModules().contains(module)) continue;
                if (production.getCalendar() == null) {
                    return production;
                }
                if (result == null) {
                    result = production;
                    continue;
                }
                if (!production.getCalendar().after(result.getCalendar())) continue;
                result = production;
            }
        }
        return result;
    }

    private void productionCheck(DefinitionContext context, Account account) {
        ProductionRepository productionRepository = (ProductionRepository)this.productionRepositoryAcceptableServiceLoader.select((Object)account);
        if (productionRepository == null) {
            return;
        }
        Modules modules = (Modules)context.getAnnotation(Modules.class);
        List productions = productionRepository.getProductionsBy(account, modules.values());
        if (productions == null || productions.size() == 0) {
            throw new ConcreteException(1103, new Object[0]);
        }
        Production production = this.findIn(productions, modules.values());
        if (production == null) {
            throw new ConcreteException(1103, new Object[0]);
        }
        Calendar overRun = production.getCalendar();
        if (overRun == null) {
            return;
        }
        Calendar now = Clock.getCalendar();
        if (now.after(overRun)) {
            throw new ConcreteException(1101, production.getProductionName());
        }
        if (production.getRemindDays() > 0) {
            now.add(5, production.getRemindDays());
            if (now.after(overRun)) {
                SubjoinWrapper.getInstance().putWarning((Warning)new WarningData(1102, production.getProductionName(), Common.calendarToStr((Calendar)production.getCalendar(), (String)"yyyy-MM-dd")));
            }
        }
    }
}

