/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.intercept.timecheckers;

import java.util.Calendar;
import java.util.StringTokenizer;
import org.coodex.concrete.common.ServiceTimingChecker;
import org.coodex.util.Clock;
import org.coodex.util.Common;

public class ByWorkDay
implements ServiceTimingChecker {
    private String weekday = "1,2,3,4,5";
    private String restDay = null;
    private String workday = null;

    public void setRestDay(String restDay) {
        this.restDay = restDay;
    }

    public void setWorkday(String workday) {
        this.workday = workday;
    }

    private boolean inWorkday(String now) {
        return this.inList(now, this.workday);
    }

    private boolean inList(String now, String dayList) {
        if (Common.isBlank((String)dayList)) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(dayList, ",");
        while (st.hasMoreElements()) {
            String s = st.nextToken();
            if (Common.isBlank((String)s) || !s.trim().equals(now)) continue;
            return true;
        }
        return false;
    }

    private boolean inRestDay(String now) {
        return this.inList(now, this.restDay);
    }

    private boolean isWeekday() {
        if (Common.isBlank((String)this.weekday)) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(this.weekday, ",");
        boolean[] weekday = new boolean[]{false, false, false, false, false, false, false};
        while (st.hasMoreElements()) {
            String s = st.nextToken();
            if (Common.isBlank((String)s)) continue;
            try {
                int num = Integer.parseInt(s.trim());
                if (num >= 7 || num < 0) continue;
                weekday[num] = true;
            }
            catch (Throwable throwable) {}
        }
        Calendar c = Clock.getCalendar();
        return weekday[c.get(7) - 1];
    }

    public void setWeekday(String weekday) {
        this.weekday = weekday;
    }

    public boolean isAllowed() {
        String now = Common.now((String)"yyyy-MM-dd");
        if (this.inWorkday(now)) {
            return true;
        }
        if (this.inRestDay(now)) {
            return false;
        }
        return this.isWeekday();
    }
}

