/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.signature;

import java.util.Arrays;
import java.util.function.Supplier;
import org.coodex.concrete.common.ConcreteContext;
import org.coodex.concrete.common.ConcreteException;
import org.coodex.concrete.common.IF;
import org.coodex.concrete.common.ServiceContext;
import org.coodex.concrete.core.signature.AbstractIronPen;
import org.coodex.concrete.core.signature.HMAC_KeyStore;
import org.coodex.concrete.core.signature.HMAC_KeyStoreDefaultImpl;
import org.coodex.util.AcceptableServiceLoader;
import org.coodex.util.DigestHelper;
import org.coodex.util.I18N;

public class HmacPen
extends AbstractIronPen {
    private static final AcceptableServiceLoader<ServiceContext, HMAC_KeyStore> HMAC_KEY_STORE_PROVIDERS = new AcceptableServiceLoader<ServiceContext, HMAC_KeyStore>((HMAC_KeyStore)new HMAC_KeyStoreDefaultImpl()){};
    private static final Supplier<String> INVALID_HMAC_KEY = () -> I18N.translate((String)"sign.invalidHMACKey");

    HmacPen(String paperName) {
        super(paperName);
    }

    private byte[] getHmacKey(String keyId) {
        return ((HMAC_KeyStore)HMAC_KEY_STORE_PROVIDERS.select((Object)ConcreteContext.getServiceContext())).getHmacKey(this.paperName, keyId);
    }

    public byte[] sign(byte[] content, String algorithm, String keyId) {
        return this.sign(content, IF.isNull(this.getHmacKey(keyId), 1015, INVALID_HMAC_KEY), algorithm);
    }

    private byte[] sign(byte[] content, byte[] key, String algorithm) {
        try {
            return DigestHelper.hmac((byte[])content, (byte[])key, (String)algorithm);
        }
        catch (Throwable th) {
            throw new ConcreteException(99999, th.getLocalizedMessage(), th);
        }
    }

    public boolean verify(byte[] content, byte[] signature, String algorithm, String keyId) {
        return Arrays.equals(signature, this.sign(content, IF.isNull(this.getHmacKey(keyId), 1016, INVALID_HMAC_KEY), algorithm));
    }
}

