/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.signature;

import org.coodex.concrete.common.ConcreteContext;
import org.coodex.concrete.common.ConcreteException;
import org.coodex.concrete.common.ServiceContext;
import org.coodex.concrete.core.signature.AbstractIronPen;
import org.coodex.concrete.core.signature.RSA_KeyStore;
import org.coodex.concrete.core.signature.RSA_KeyStoreDefaultImpl;
import org.coodex.util.AcceptableServiceLoader;
import org.coodex.util.Common;
import org.coodex.util.RSACommon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSAPen
extends AbstractIronPen {
    private static final Logger log = LoggerFactory.getLogger(RSAPen.class);
    private static final AcceptableServiceLoader<ServiceContext, RSA_KeyStore> RSA_KEY_STORE_PROVIDERS = new AcceptableServiceLoader<ServiceContext, RSA_KeyStore>((RSA_KeyStore)new RSA_KeyStoreDefaultImpl()){};

    RSAPen(String paperName) {
        super(paperName);
    }

    private String nullToDefault(String algorithm) {
        return Common.isBlank((String)algorithm) ? "SHA256withRSA" : algorithm;
    }

    public byte[] sign(byte[] content, String algorithm, String keyId) {
        try {
            return RSACommon.sign((byte[])((RSA_KeyStore)RSA_KEY_STORE_PROVIDERS.select((Object)ConcreteContext.getServiceContext())).getPrivateKey(this.paperName, keyId), (byte[])content, (String)this.nullToDefault(algorithm));
        }
        catch (Throwable th) {
            throw new ConcreteException(99999, th.getLocalizedMessage(), th);
        }
    }

    public boolean verify(byte[] content, byte[] signature, String algorithm, String keyId) {
        try {
            return RSACommon.verify((byte[])((RSA_KeyStore)RSA_KEY_STORE_PROVIDERS.select((Object)ConcreteContext.getServiceContext())).getPublicKey(this.paperName, keyId), (byte[])content, (byte[])signature, (String)this.nullToDefault(algorithm));
        }
        catch (Throwable th) {
            throw new ConcreteException(99999, th.getLocalizedMessage(), th);
        }
    }
}

