/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.token;

import java.io.Serializable;
import java.util.Enumeration;
import org.coodex.concrete.common.Account;
import org.coodex.concrete.common.Token;
import org.coodex.concrete.core.token.TokenWrapper;

public class TokenProxy
implements Token {
    private Token proxy;

    private TokenProxy(Token proxy) {
        this.proxy = proxy;
    }

    public static Token proxy(String tokenId) {
        return new TokenProxy(tokenId == null ? null : TokenWrapper.getToken(tokenId));
    }

    public long created() {
        return this.proxy == null ? 0L : this.proxy.created();
    }

    public boolean isValid() {
        return this.proxy == null || this.proxy.isValid();
    }

    public void invalidate() {
        if (this.proxy != null) {
            this.proxy.invalidate();
        }
    }

    public Account currentAccount() {
        return this.proxy == null ? null : this.proxy.currentAccount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Token forSet() {
        if (this.proxy == null || !this.proxy.isValid()) {
            TokenProxy tokenProxy = this;
            synchronized (tokenProxy) {
                if (this.proxy == null || !this.proxy.isValid()) {
                    this.proxy = TokenWrapper.newToken();
                }
            }
        }
        return this.proxy;
    }

    public void setAccount(Account account) {
        this.forSet().setAccount(account);
    }

    public boolean isAccountCredible() {
        return this.proxy == null ? false : this.proxy.isAccountCredible();
    }

    public void setAccountCredible(boolean credible) {
        this.forSet().setAccountCredible(credible);
    }

    public String getTokenId() {
        return this.proxy == null ? null : this.proxy.getTokenId();
    }

    @Deprecated
    public <T> T getAttribute(String key) {
        return (T)(this.proxy == null ? null : this.proxy.getAttribute(key));
    }

    public <T> T getAttribute(String key, Class<T> clz) {
        return (T)(this.proxy == null ? null : this.proxy.getAttribute(key, clz));
    }

    public void setAttribute(String key, Serializable attribute) {
        this.forSet().setAttribute(key, attribute);
    }

    public void removeAttribute(String key) {
        if (this.proxy != null) {
            this.proxy.removeAttribute(key);
        }
    }

    public Enumeration<String> attributeNames() {
        return this.proxy == null ? null : this.proxy.attributeNames();
    }

    public void flush() {
        if (this.proxy != null) {
            this.proxy.flush();
        }
    }

    public void renew() {
        if (this.proxy != null) {
            this.proxy.renew();
        }
    }
}

