/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.client;

import java.util.Locale;
import org.coodex.concrete.client.ClientTokenManagement;
import org.coodex.concrete.client.Destination;
import org.coodex.concrete.common.ConcreteContext;
import org.coodex.concrete.common.DefinitionContext;
import org.coodex.concrete.common.IF;
import org.coodex.concrete.common.ServiceContext;
import org.coodex.concrete.common.Subjoin;
import org.coodex.concrete.common.SubjoinWrapper;

public abstract class ClientSideContext
implements ServiceContext {
    private String tokenId;
    private Subjoin subjoin = new SubjoinWrapper.DefaultSubjoin();
    private Locale locale;
    private Destination destination;
    private DefinitionContext definitionContext;

    public ClientSideContext(Destination destination, DefinitionContext definitionContext) {
        this.init(definitionContext);
        this.destination = destination;
        ServiceContext serviceContext = ConcreteContext.getServiceContext();
        this.tokenId = serviceContext == null ? ClientTokenManagement.getTokenId(destination) : ClientTokenManagement.getTokenId(destination, serviceContext.getTokenId());
        this.locale = serviceContext == null ? Locale.getDefault() : serviceContext.getLocale();
    }

    @Override
    public String getTokenId() {
        return this.tokenId;
    }

    public Destination getDestination() {
        return this.destination;
    }

    private void init(DefinitionContext definitionContext) {
        this.definitionContext = IF.isNull(definitionContext, "Definition MUST NOT null.");
    }

    public DefinitionContext getDefinitionContext() {
        return this.definitionContext;
    }

    @Override
    public Subjoin getSubjoin() {
        return this.subjoin;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public void responseSubjoin(Subjoin subjoin) {
        this.subjoin = subjoin;
    }
}

