/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.common;

import org.coodex.concrete.common.LogFormatter;
import org.coodex.concrete.common.MessageFormatter;
import org.coodex.concrete.core.JavaTextFormatMessageFormatter;
import org.coodex.util.ServiceLoader;
import org.coodex.util.ServiceLoaderImpl;

public class AbstractMessageFacade {
    private static final MessageFormatter DEFAULT_MESSAGE_FORMATTER = new JavaTextFormatMessageFormatter();
    private static final LogFormatter DEFAULT_LOG_FORMATTER = (pattern, values) -> values == null ? null : values.toString();
    private static final ServiceLoader<MessageFormatter> MESSAGE_FORMATTER_SERVICE_LOADER = new ServiceLoaderImpl<MessageFormatter>(DEFAULT_MESSAGE_FORMATTER){};
    private static final ServiceLoader<LogFormatter> LOG_FORMATTER_SERVICE_LOADER = new ServiceLoaderImpl<LogFormatter>(DEFAULT_LOG_FORMATTER){};

    public static MessageFormatter getFormatter(Class<? extends MessageFormatter> formatterClass) {
        MessageFormatter formatter = formatterClass == null || formatterClass == MessageFormatter.class ? (MessageFormatter)MESSAGE_FORMATTER_SERVICE_LOADER.get() : (MessageFormatter)MESSAGE_FORMATTER_SERVICE_LOADER.get(formatterClass);
        return formatter == null ? DEFAULT_MESSAGE_FORMATTER : formatter;
    }

    public static LogFormatter getLogFormatter(Class<? extends LogFormatter> formatterClass) {
        return formatterClass == null || formatterClass == LogFormatter.class ? (LogFormatter)LOG_FORMATTER_SERVICE_LOADER.get() : (LogFormatter)LOG_FORMATTER_SERVICE_LOADER.get(formatterClass);
    }
}

