/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.common;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.coodex.concrete.api.ConcreteService;
import org.coodex.concrete.api.Overlay;
import org.coodex.concrete.common.DefinitionContext;

public class DefinitionContextImpl
implements DefinitionContext {
    private Class<?> declaringClass;
    private Method declaringMethod;

    DefinitionContextImpl() {
    }

    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    void setDeclaringClass(Class<?> declaringClass) {
        this.declaringClass = declaringClass;
    }

    public Method getDeclaringMethod() {
        return this.declaringMethod;
    }

    void setDeclaringMethod(Method declaringMethod) {
        this.declaringMethod = declaringMethod;
    }

    public String getModuleName() {
        if (this.declaringClass == null) {
            return null;
        }
        ConcreteService concreteService = this.declaringClass.getAnnotation(ConcreteService.class);
        if (concreteService == null) {
            return null;
        }
        return concreteService.value();
    }

    public final <T extends Annotation> T getDeclaringAnnotation(Class<T> annotationClass) {
        return this.getDeclaringMethod().getAnnotation(annotationClass);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        AnnotatedElement[] annotatedElementArray;
        boolean overlay;
        Overlay overlayAnnotation = annotationClass.getAnnotation(Overlay.class);
        boolean bl = overlay = overlayAnnotation != null && overlayAnnotation.overlay();
        if (overlay) {
            AnnotatedElement[] annotatedElementArray2 = new AnnotatedElement[3];
            annotatedElementArray2[0] = this.declaringMethod;
            annotatedElementArray2[1] = this.declaringClass;
            annotatedElementArray = annotatedElementArray2;
            annotatedElementArray2[2] = this.declaringMethod.getDeclaringClass();
        } else {
            AnnotatedElement[] annotatedElementArray3 = new AnnotatedElement[3];
            annotatedElementArray3[0] = this.declaringMethod;
            annotatedElementArray3[1] = this.declaringMethod.getDeclaringClass();
            annotatedElementArray = annotatedElementArray3;
            annotatedElementArray3[2] = this.declaringClass;
        }
        return this.getAnnotationFrom(annotationClass, annotatedElementArray);
    }

    protected <T extends Annotation> T getAnnotationFrom(Class<T> annotationClass, AnnotatedElement ... accessibleObjects) {
        for (AnnotatedElement annotatedElement : accessibleObjects) {
            T annotation;
            if (annotatedElement == null || (annotation = annotatedElement.getAnnotation(annotationClass)) == null) continue;
            return annotation;
        }
        return null;
    }
}

