/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.intercept;

import java.io.Serializable;
import java.lang.reflect.Type;
import javax.inject.Inject;
import org.aopalliance.intercept.MethodInvocation;
import org.coodex.concrete.common.ConcreteException;
import org.coodex.concrete.common.DefinitionContext;
import org.coodex.concrete.common.Token;
import org.coodex.concrete.core.intercept.AbstractInterceptor;
import org.coodex.concrete.core.intercept.TBTSManager;
import org.coodex.concrete.core.intercept.annotations.ServerSide;
import org.coodex.concrete.core.intercept.annotations.TestContext;
import org.coodex.concrete.message.MessageConsumer;
import org.coodex.concrete.message.MessageFilter;
import org.coodex.concrete.message.TokenBasedTopic;
import org.coodex.concrete.message.Topics;
import org.coodex.util.Common;
import org.coodex.util.GenericTypeHelper;
import org.coodex.util.Singleton;

@ServerSide
@TestContext
public abstract class AbstractTokenBasedTopicSubscribeInterceptor<M extends Serializable>
extends AbstractInterceptor {
    @Inject
    private Token token;
    private Singleton<TokenBasedTopic<M>> tokenBasedTopicSingleton = new Singleton(this::buildTopic);

    private TokenBasedTopic<M> buildTopic() {
        MessageConsumer messageConsumer = this.getClass().getAnnotation(MessageConsumer.class);
        String queue = null;
        Class<TokenBasedTopic> clz = TokenBasedTopic.class;
        if (messageConsumer != null) {
            queue = messageConsumer.queue();
            if (TokenBasedTopic.class.isAssignableFrom(messageConsumer.topicType())) {
                clz = messageConsumer.topicType();
            }
        }
        if (clz.getTypeParameters().length == 1) {
            return (TokenBasedTopic)Topics.get(GenericTypeHelper.buildParameterizedType(clz, (Type[])new Type[]{this.getMessageType()}), queue);
        }
        if (clz.getTypeParameters().length == 0) {
            return (TokenBasedTopic)Topics.get(clz, queue);
        }
        throw new ConcreteException(1017, clz);
    }

    private Type getMessageType() {
        return GenericTypeHelper.solveFromInstance(AbstractTokenBasedTopicSubscribeInterceptor.class.getTypeParameters()[0], (Object)this);
    }

    @Override
    protected boolean accept_(DefinitionContext context) {
        return this.check_();
    }

    protected abstract MessageFilter<M> subscribe();

    private boolean checkAccountCredible() {
        return true;
    }

    protected abstract boolean check();

    private TokenBasedTopic<M> getTopic() {
        return (TokenBasedTopic)this.tokenBasedTopicSingleton.get();
    }

    private boolean check_() {
        if (this.checkAccountCredible()) {
            return this.token.isAccountCredible() && this.check();
        }
        return this.check();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object after(DefinitionContext context, MethodInvocation joinPoint, Object result) {
        if (this.token.isValid()) {
            if (!Common.isBlank((String)this.token.getTokenId())) {
                Object object = TBTSManager.tokenLock(this.token);
                synchronized (object) {
                    MessageFilter<M> observer;
                    if (this.check_() && (observer = this.subscribe()) != null) {
                        TBTSManager.putSubscription(this.getTopic().subscribe(observer));
                    }
                }
            }
        } else {
            TBTSManager.cancel(this.token);
        }
        return super.after(context, joinPoint, result);
    }

    @Override
    public int getOrder() {
        return 10001;
    }
}

