/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.intercept;

import java.util.concurrent.atomic.AtomicInteger;
import org.coodex.concrete.api.LimitingStrategy;
import org.coodex.concrete.api.limiting.MaximumConcurrency;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.DefinitionContext;
import org.coodex.config.Config;
import org.coodex.util.Common;
import org.coodex.util.SingletonMap;

public class MaximumConcurrencyLimiting
implements LimitingStrategy {
    private static final String TAG_MC = "limiting.maximum.concurrency";
    private static final SingletonMap<String, ConcurrencyStrategy> STRATEGY_SINGLETON_MAP = new SingletonMap(ConcurrencyStrategy::new);

    public boolean apply(DefinitionContext definitionContext) {
        ConcurrencyStrategy strategy = this.getConcurrencyStrategy(definitionContext);
        return strategy == null || strategy.alloc();
    }

    private ConcurrencyStrategy getConcurrencyStrategy(DefinitionContext context) {
        ConcurrencyStrategy strategy = null;
        MaximumConcurrency maximumConcurrency = (MaximumConcurrency)context.getAnnotation(MaximumConcurrency.class);
        if (maximumConcurrency != null) {
            strategy = (ConcurrencyStrategy)STRATEGY_SINGLETON_MAP.get((Object)maximumConcurrency.strategy());
        }
        return strategy;
    }

    public void release(DefinitionContext context) {
        ConcurrencyStrategy strategy = this.getConcurrencyStrategy(context);
        if (strategy != null) {
            strategy.release();
        }
    }

    public boolean accept(DefinitionContext param) {
        return param.getAnnotation(MaximumConcurrency.class) != null;
    }

    static class ConcurrencyStrategy {
        private final AtomicInteger counter = new AtomicInteger(0);
        private final String strategyName;

        public ConcurrencyStrategy(String strategyName) {
            this.strategyName = strategyName;
        }

        public synchronized boolean alloc() {
            if ((long)this.counter.get() < this.getMaximum()) {
                this.counter.incrementAndGet();
                return true;
            }
            return false;
        }

        public synchronized void release() {
            this.counter.decrementAndGet();
        }

        public long getMaximum() {
            return ((Integer)Config.getValue((String)"max", (Object)Common.toInt((String)System.getProperty("limiting.maximum.concurrency.max"), (int)Integer.MAX_VALUE), (String[])new String[]{MaximumConcurrencyLimiting.TAG_MC, ConcreteHelper.getAppSet(), this.strategyName})).intValue();
        }
    }
}

