/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.intercept;

import org.aopalliance.intercept.MethodInvocation;
import org.coodex.concrete.api.AccessAllow;
import org.coodex.concrete.api.Domain;
import org.coodex.concrete.api.Safely;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.DefinitionContext;
import org.coodex.concrete.common.RBACHelper;
import org.coodex.concrete.core.intercept.AbstractInterceptor;
import org.coodex.concrete.core.intercept.annotations.Default;
import org.coodex.concrete.core.intercept.annotations.ServerSide;
import org.coodex.concrete.core.intercept.annotations.TestContext;
import org.coodex.config.Config;
import org.coodex.util.Common;

@ServerSide
@TestContext
@Default
public class RBACInterceptor
extends AbstractInterceptor {
    @Override
    public int getOrder() {
        return 9000;
    }

    @Override
    protected boolean accept_(DefinitionContext context) {
        return context.getAnnotation(AccessAllow.class) != null;
    }

    @Override
    public void before(DefinitionContext context, MethodInvocation joinPoint) {
        if (context.getDeclaringMethod() != null) {
            AccessAllow accessAllow;
            Domain owner;
            String[] acl = Config.getArray((String)(context.getDeclaringMethod().getName() + "." + context.getDeclaringMethod().getParameterTypes().length), (String[])new String[]{ConcreteHelper.getAppSet()});
            String domain = Config.get((String)"domain", (String[])new String[]{ConcreteHelper.getAppSet()});
            if (domain == null && (owner = (Domain)context.getAnnotation(Domain.class)) != null && !Common.isBlank((String)owner.value().trim())) {
                domain = owner.value();
            }
            if (acl == null && (accessAllow = (AccessAllow)context.getAnnotation(AccessAllow.class)) != null && (acl = accessAllow.roles()).length == 0) {
                acl = new String[]{"EVERYBODY"};
            }
            this.rbac(acl, domain, context.getAnnotation(Safely.class) != null);
        }
    }

    public void rbac(String[] acl, String domain, boolean safely) {
        RBACHelper.rbac(acl, domain, safely);
    }
}

