/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.mocker;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.coodex.concrete.api.mockers.IdCard;
import org.coodex.pojomocker.AbstractMocker;
import org.coodex.util.Clock;
import org.coodex.util.Common;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class IdCardMocker
extends AbstractMocker<IdCard> {
    private static final Logger log = LoggerFactory.getLogger(IdCardMocker.class);
    private final List<String> administrative_divisions = new ArrayList<String>();

    public static char getVerifyChar(String idCardNumber) {
        char[] pszSrc = idCardNumber.toCharArray();
        int iS = 0;
        int[] iW = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
        char[] szVerCode = new char[]{'1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2'};
        for (int i = 0; i < 17; ++i) {
            iS += (pszSrc[i] - 48) * iW[i];
        }
        int iY = iS % 11;
        return szVerCode[iY];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object mock(IdCard mockAnnotation, Class clazz) {
        List<String> list = this.administrative_divisions;
        synchronized (list) {
            if (this.administrative_divisions.size() == 0) {
                try {
                    this.loadDivisions();
                }
                catch (Throwable th) {
                    log.warn("{}", (Object)th.getLocalizedMessage(), (Object)th);
                    this.administrative_divisions.add("430202");
                }
            }
        }
        int size = mockAnnotation == null ? 18 : mockAnnotation.specification().getSize();
        StringBuilder builder = new StringBuilder(this.getDivision(mockAnnotation == null ? null : mockAnnotation.divisions()));
        builder.append(size == 15 ? this.birthDay(mockAnnotation).substring(2) : this.birthDay(mockAnnotation));
        int sex = mockAnnotation == null ? IdCard.Sex.RANDOM.getSex() : mockAnnotation.sex().getSex();
        int num = Common.random((int)1, (int)998);
        if (num % 2 != sex) {
            ++num;
        }
        builder.append(String.format("%03d", num));
        String idCard = builder.toString();
        return size == 15 ? idCard : idCard + IdCardMocker.getVerifyChar(idCard);
    }

    private String birthDay(IdCard mock) {
        int minAge = mock == null ? 5 : Math.max(5, mock.minAge());
        int maxAge = mock == null ? 90 : Math.max(minAge + 10, Math.min(90, mock.maxAge()));
        int thisYear = Clock.now().get(1);
        int year = Common.random((int)(thisYear - maxAge), (int)(thisYear - minAge));
        int month = Common.random((int)1, (int)12);
        return String.format("%d%02d%02d", year, month, Common.random((int)1, (int)this.days(year, month)));
    }

    private int days(int year, int month) {
        switch (month) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return 31;
            }
            case 2: {
                return year % 4 == 0 ? 29 : 28;
            }
        }
        return 30;
    }

    private String getDivision(String[] divisions) {
        List<String> range = this.filter(divisions);
        return range.get(Common.random((int)(range.size() - 1)));
    }

    private List<String> filter(String[] divisions) {
        ArrayList<String> result = new ArrayList<String>();
        for (String division : this.administrative_divisions) {
            boolean ok = true;
            if (divisions != null && divisions.length > 0) {
                ok = false;
                String[] stringArray = divisions;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String rule = stringArray[i];
                    if (rule == null || rule.length() <= 0 || !division.startsWith(rule)) continue;
                    ok = true;
                    break;
                }
            }
            if (!ok) continue;
            result.add(division);
        }
        if (result.size() == 0) {
            StringBuilder builder = new StringBuilder("\u65e0\u5339\u914d\u7684\u884c\u653f\u533a\u5212: [");
            boolean isFirst = true;
            if (divisions != null && divisions.length > 0) {
                for (String division : divisions) {
                    if (!isFirst) {
                        builder.append(", ");
                    }
                    builder.append(division);
                    isFirst = false;
                }
            }
            builder.append("].");
            throw new RuntimeException(builder.toString());
        }
        return result;
    }

    private void loadDivisions() throws IOException {
        URL url = Common.getResource((String)"administrative_divisions.txt", (ClassLoader[])new ClassLoader[]{IdCardMocker.class.getClassLoader()});
        InputStream is = url.openStream();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.length() <= 8 || line.charAt(0) != '\u3000' || line.charAt(1) != '\u3000' || line.endsWith("\u5e02\u8f96\u533a")) continue;
                this.administrative_divisions.add(line.substring(2, 8));
            }
        }
    }
}

