/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.signature;

import java.util.ArrayList;
import org.coodex.concrete.client.ClientSideContext;
import org.coodex.concrete.common.ConcreteContext;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.ServiceContext;
import org.coodex.concrete.core.signature.HMAC_KeyStore;
import org.coodex.concrete.core.signature.HmacKeyStore;
import org.coodex.concrete.core.signature.SignUtil;
import org.coodex.config.Config;
import org.coodex.util.Common;
import org.coodex.util.ServiceLoader;
import org.coodex.util.ServiceLoaderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HMAC_KeyStoreDefaultImpl
implements HMAC_KeyStore {
    private static final Logger log = LoggerFactory.getLogger(HMAC_KeyStoreDefaultImpl.class);
    private static ServiceLoader<HmacKeyStore> COMPATIBILITY_LOADER = new ServiceLoaderImpl<HmacKeyStore>(new HmacKeyStore(){

        @Override
        public byte[] getHmacKey(String paperName, String keyId) {
            String s = HMAC_KeyStoreDefaultImpl.getHmacKeyStr(paperName, keyId);
            return s == null ? null : s.getBytes();
        }
    }){};

    private static String getHmacKeyStr(String paperName, String keyId) {
        if (Common.isBlank((String)keyId)) {
            return SignUtil.getString("hmacKey", paperName, null);
        }
        String key = null;
        if (!Common.isBlank((String)paperName) && (key = SignUtil.getString("hmacKey." + paperName + "." + keyId, null, null)) == null) {
            key = SignUtil.getString("hmacKey." + paperName, null, null);
        }
        if (key == null) {
            key = SignUtil.getString("hmacKey", keyId, null);
        }
        return key == null ? SignUtil.getString("hmacKey", null, null) : key;
    }

    private static String getHmacKeyStr(String paperName, String keyId, String module) {
        ArrayList<String> namespace = new ArrayList<String>();
        namespace.add(module == null ? "signature" : "client");
        if (module != null) {
            namespace.add(module);
        }
        namespace.add(ConcreteHelper.getAppSet());
        String[] namespaceArray = namespace.toArray(new String[0]);
        boolean blankPaper = Common.isBlank((String)paperName);
        String hmacKeyProperty = module == null ? "hmacKey" : "signature.hmacKey";
        String key = null;
        if (Common.isBlank((String)keyId)) {
            if (!blankPaper) {
                key = Config.get((String)String.format("%s.%s", hmacKeyProperty, paperName), (String[])namespaceArray);
            }
            if (key == null) {
                key = Config.get((String)hmacKeyProperty, (String[])namespaceArray);
            }
        } else {
            key = Config.get((String)String.format("%s.%s", hmacKeyProperty, (blankPaper ? "" : paperName + ".") + keyId), (String[])namespaceArray);
            if (key == null) {
                key = Config.get((String)(hmacKeyProperty + (blankPaper ? "" : "." + paperName)), (String[])namespaceArray);
            }
        }
        return key;
    }

    private String getModule() {
        ServiceContext context = ConcreteContext.getServiceContext();
        return context instanceof ClientSideContext ? ((ClientSideContext)context).getDestination().getIdentify() : null;
    }

    @Override
    public byte[] getHmacKey(String paperName, String keyId) {
        String s = HMAC_KeyStoreDefaultImpl.getHmacKeyStr(paperName, keyId, this.getModule());
        if (s != null) {
            return s.getBytes();
        }
        log.warn("{} deprecated. use {} plz.", (Object)HmacKeyStore.class.getName(), (Object)HMAC_KeyStore.class.getName());
        return ((HmacKeyStore)COMPATIBILITY_LOADER.get()).getHmacKey(paperName, keyId);
    }

    public boolean accept(ServiceContext param) {
        return true;
    }
}

