/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.signature;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.coodex.concrete.common.ConcreteException;
import org.coodex.concrete.common.ServiceContext;
import org.coodex.concrete.core.signature.RSAKeyStore;
import org.coodex.concrete.core.signature.RSAKeyStoreDefaultImpl;
import org.coodex.concrete.core.signature.RSA_KeyStore;
import org.coodex.concrete.core.signature.SignUtil;
import org.coodex.util.Common;
import org.coodex.util.ServiceLoaderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSA_KeyStoreDefaultImpl
implements RSA_KeyStore {
    private static final Logger log = LoggerFactory.getLogger(RSA_KeyStoreDefaultImpl.class);
    private static final ServiceLoaderImpl<RSAKeyStore> COMPATIBILITY_LOADER = new ServiceLoaderImpl<RSAKeyStore>((RSAKeyStore)new RSAKeyStoreDefaultImpl()){};

    static byte[] loadKey(List<String> properties, List<String> resources) throws IOException {
        Object property;
        String s = null;
        Iterator<String> iterator = properties.iterator();
        while (iterator.hasNext() && (s = SignUtil.getString((String)(property = iterator.next()), null, null)) == null) {
        }
        if (s == null) {
            URL url = null;
            for (String resource : resources) {
                url = Common.getResource((String)("rsaKeys/" + resource), (ClassLoader[])new ClassLoader[0]);
                if (url == null) continue;
                break;
            }
            if (url != null) {
                try (InputStream is = url.openStream();){
                    s = RSA_KeyStoreDefaultImpl.loadFromInputStream(is);
                }
            }
        }
        return s == null ? null : Base64.decodeBase64(s);
    }

    private static String loadFromInputStream(InputStream is) throws IOException {
        String s;
        if (is == null) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder builder = new StringBuilder();
        while ((s = reader.readLine()) != null) {
            builder.append(s);
        }
        return builder.toString();
    }

    static List<String> getConfigKeys(String paperName, String keyId, String type) {
        ArrayList<String> list = new ArrayList<String>();
        boolean paperNameIsBlank = Common.isBlank((String)paperName);
        boolean keyIdIsBlank = Common.isBlank((String)keyId);
        if (!paperNameIsBlank) {
            if (!keyIdIsBlank) {
                list.add("rsa." + type + "." + paperName + "." + keyId);
            }
            list.add("rsa." + type + "." + paperName);
        }
        if (!keyIdIsBlank) {
            list.add("rsa." + type + "." + keyId);
        }
        list.add("rsa." + type);
        return list;
    }

    static List<String> getResourceList(String paperName, String keyId, String type) {
        ArrayList<String> list = new ArrayList<String>();
        boolean paperNameIsBlank = Common.isBlank((String)paperName);
        boolean keyIdIsBlank = Common.isBlank((String)keyId);
        if (!keyIdIsBlank) {
            if (!paperNameIsBlank) {
                list.add(paperName + "." + keyId + "." + type);
            }
            list.add(keyId + "." + type);
        }
        if (!paperNameIsBlank) {
            list.add(paperName + "." + type);
        }
        return list;
    }

    @Override
    public byte[] getPrivateKey(String paperName, String keyId) {
        byte[] bytes = ((RSAKeyStore)COMPATIBILITY_LOADER.get()).getPrivateKey(paperName);
        if (bytes != null) {
            log.warn("{} deprecated. use {} plz.", (Object)RSAKeyStore.class.getName(), (Object)RSA_KeyStore.class.getName());
            return bytes;
        }
        try {
            return RSA_KeyStoreDefaultImpl.loadKey(RSA_KeyStoreDefaultImpl.getConfigKeys(paperName, keyId, "privateKey"), RSA_KeyStoreDefaultImpl.getResourceList(paperName, keyId, "pem"));
        }
        catch (IOException e) {
            throw new ConcreteException(1019, paperName, keyId, e.getLocalizedMessage());
        }
    }

    @Override
    public byte[] getPublicKey(String paperName, String keyId) {
        byte[] bytes = ((RSAKeyStore)COMPATIBILITY_LOADER.get()).getPublicKey(paperName, keyId);
        if (bytes != null) {
            log.warn("{} deprecated. use {} plz.", (Object)RSAKeyStore.class.getName(), (Object)RSA_KeyStore.class.getName());
            return bytes;
        }
        try {
            return RSA_KeyStoreDefaultImpl.loadKey(RSA_KeyStoreDefaultImpl.getConfigKeys(paperName, keyId, "publicKey"), RSA_KeyStoreDefaultImpl.getResourceList(paperName, keyId, "crt"));
        }
        catch (IOException e) {
            throw new ConcreteException(1019, paperName, keyId, e.getLocalizedMessage());
        }
    }

    public boolean accept(ServiceContext param) {
        return true;
    }
}

