/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.token;

import java.io.Serializable;
import java.util.Enumeration;
import org.coodex.concrete.common.Account;
import org.coodex.concrete.common.BeanServiceLoaderProvider;
import org.coodex.concrete.common.ConcreteContext;
import org.coodex.concrete.common.ConcreteException;
import org.coodex.concrete.common.ContainerContext;
import org.coodex.concrete.common.IF;
import org.coodex.concrete.common.ServiceContext;
import org.coodex.concrete.common.Token;
import org.coodex.concrete.core.token.TokenManager;
import org.coodex.concrete.core.token.TokenProxy;
import org.coodex.concrete.core.token.local.LocalTokenManager;
import org.coodex.util.Singleton;

public class TokenWrapper
implements Token {
    private static final Token singletonInstance = new TokenWrapper();
    private static Singleton<TokenManager> tokenManager = new Singleton(() -> {
        try {
            return BeanServiceLoaderProvider.getBeanProvider().getBean(TokenManager.class);
        }
        catch (ConcreteException ce) {
            if (ce.getCode() == 1011) {
                return new LocalTokenManager();
            }
            throw ce;
        }
    });

    public static final Token getInstance() {
        return singletonInstance;
    }

    public static Token getToken(String id) {
        return ((TokenManager)tokenManager.get()).getToken(id);
    }

    public static Token newToken() {
        return ((TokenManager)tokenManager.get()).newToken();
    }

    private Token getToken() {
        return this.getToken(true);
    }

    private Token getToken(boolean checkValidation) {
        Token token = null;
        ServiceContext context = ConcreteContext.getServiceContext();
        if (context instanceof ContainerContext) {
            token = ((ContainerContext)context).getToken();
        }
        IF.is(checkValidation && token != null && !token.isValid(), 1004, token == null ? null : token.getTokenId());
        return token == null ? TokenProxy.proxy(null) : token;
    }

    public String toString() {
        return "tokenId: " + this.getTokenId();
    }

    public void renew() {
        this.getToken(false).renew();
    }

    public long created() {
        return this.getToken().created();
    }

    public boolean isValid() {
        return this.getToken(false).isValid();
    }

    public void invalidate() {
        this.getToken().invalidate();
    }

    public Account currentAccount() {
        return this.getToken().currentAccount();
    }

    public void setAccount(Account account) {
        this.getToken().setAccount(account);
    }

    public boolean isAccountCredible() {
        return this.getToken().isAccountCredible();
    }

    public void setAccountCredible(boolean credible) {
        this.getToken().setAccountCredible(credible);
    }

    public String getTokenId() {
        return this.getToken(false).getTokenId();
    }

    @Deprecated
    public <T> T getAttribute(String key) {
        return (T)this.getToken().getAttribute(key);
    }

    public <T> T getAttribute(String key, Class<T> clz) {
        return (T)this.getToken().getAttribute(key, clz);
    }

    public void setAttribute(String key, Serializable attribute) {
        this.getToken().setAttribute(key, attribute);
    }

    public void removeAttribute(String key) {
        this.getToken().removeAttribute(key);
    }

    public Enumeration<String> attributeNames() {
        return this.getToken().attributeNames();
    }

    public void flush() {
        this.getToken().flush();
    }
}

