/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.message;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import org.coodex.concrete.message.AggregatedCourier;
import org.coodex.concrete.message.AggregatedCourierPrototypeProvider;
import org.coodex.concrete.message.CourierPrototype;
import org.coodex.concrete.message.Topic;
import org.coodex.concrete.message.Topics;
import org.coodex.util.Common;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AggregatedCourierPrototype<M extends Serializable>
extends CourierPrototype<M>
implements AggregatedCourier {
    private static final Logger log = LoggerFactory.getLogger(AggregatedCourierPrototype.class);
    private Set<Topic<M>> topics = new LinkedHashSet<Topic<M>>();

    public AggregatedCourierPrototype(String queue, String destination, Type topicType) {
        super(queue, destination, topicType);
        Common.toArray((String)AggregatedCourierPrototypeProvider.AGGREGATED_PATTERN.matcher(destination).group(1), (String)",", new ArrayList()).forEach(q -> {
            String a = q.trim();
            if (!Common.isBlank((String)a)) {
                return;
            }
            this.topics.add((Topic<M>)Topics.get(topicType, a));
        });
        if (this.topics.size() == 0) {
            throw new RuntimeException("none topic queue aggregated.");
        }
    }

    @Override
    protected void afterTopicAssociation() {
    }

    @Override
    public void deliver(M message) {
        for (Topic<M> topic : this.topics) {
            try {
                topic.publish(message);
            }
            catch (Throwable th) {
                log.warn("aggregated send failed: {}", (Object)th.getLocalizedMessage(), (Object)th);
            }
        }
    }

    @Override
    public boolean isConsumer() {
        return false;
    }

    @Override
    public void setConsumer(boolean consumer) {
    }
}

