/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.message;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicLong;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.bytecode.ClassFile;
import javassist.bytecode.SignatureAttribute;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.bytecode.javassist.JavassistHelper;
import org.coodex.concrete.message.AbstractTopic;
import org.coodex.concrete.message.Courier;
import org.coodex.concrete.message.CourierPrototype;
import org.coodex.concrete.message.CourierPrototypeProvider;
import org.coodex.concrete.message.LocalCourierPrototype;
import org.coodex.concrete.message.TopicKey;
import org.coodex.util.Common;
import org.coodex.util.GenericTypeHelper;
import org.coodex.util.LazySelectableServiceLoader;
import org.coodex.util.SingletonMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CourierBuilder
implements SingletonMap.Builder<TopicKey, Courier> {
    private static final Logger log = LoggerFactory.getLogger(CourierBuilder.class);
    private static SingletonMap<TopicKey, Courier> couriers = new SingletonMap((SingletonMap.Builder)new CourierBuilder());
    private static LazySelectableServiceLoader<String, CourierPrototypeProvider> providers = new LazySelectableServiceLoader<String, CourierPrototypeProvider>(){};
    private AtomicLong index = new AtomicLong(0L);

    CourierBuilder() {
    }

    static <M extends Serializable> Courier<M> buildCourier(TopicKey topicKey) {
        return (Courier)couriers.get((Object)topicKey);
    }

    private static String getDestination(String queue) {
        if (queue == null) {
            return null;
        }
        return ConcreteHelper.getString("queue", queue, "destination");
    }

    static Type getMessageType(Type topicType) {
        return GenericTypeHelper.solveFromType(AbstractTopic.class.getTypeParameters()[0], (Type)topicType);
    }

    private Class<? extends CourierPrototype> getLocalCourierPrototype(String queue, String destination) {
        if (destination != null && queue != null) {
            log.warn("CourierPrototype not found for queue[{}]: {}", (Object)queue, (Object)destination);
        }
        return LocalCourierPrototype.class;
    }

    public Courier build(TopicKey key) {
        try {
            String destination = CourierBuilder.getDestination(key.queue);
            CourierPrototypeProvider provider = null;
            if (!Common.isBlank((String)destination)) {
                provider = (CourierPrototypeProvider)providers.select((Object)destination);
            }
            Class<? extends CourierPrototype> prototype = provider == null ? this.getLocalCourierPrototype(key.queue, destination) : provider.getPrototype();
            String className = String.format("%s.Courier$$CBC$$%08X", CourierBuilder.class.getPackage().getName(), this.index.incrementAndGet());
            ClassPool classPool = ClassPool.getDefault();
            CtClass ctClass = classPool.makeClass(className, classPool.getOrNull(prototype.getName()));
            ClassFile classFile = ctClass.getClassFile();
            classFile.setVersionToJava5();
            ctClass.setGenericSignature(new SignatureAttribute.ClassSignature(null, JavassistHelper.classType(prototype.getName(), CourierBuilder.getMessageType(key.topicType)), null).encode());
            CtConstructor ctConstructor = new CtConstructor(new CtClass[]{classPool.getOrNull(String.class.getName()), classPool.getOrNull(String.class.getName()), classPool.getOrNull(Type.class.getName())}, ctClass);
            ctConstructor.setBody("{super($$);}");
            ctClass.addConstructor(ctConstructor);
            Class courierClass = (Boolean)JavassistHelper.IS_JAVA_9_AND_LAST.get() != false ? ctClass.toClass(CourierBuilder.class) : ctClass.toClass();
            Constructor courierConstructor = courierClass.getConstructor(String.class, String.class, Type.class);
            Courier courier = (Courier)courierConstructor.newInstance(key.queue, destination, key.topicType);
            log.info("Courier build. {}, {}", (Object)courierClass.getName(), (Object)key.toString());
            return courier;
        }
        catch (Throwable th) {
            throw Common.runtimeException((Throwable)th);
        }
    }
}

