/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.message;

import java.io.Serializable;
import java.lang.reflect.Type;
import org.coodex.concrete.message.AbstractTopic;
import org.coodex.concrete.message.AbstractTopicPrototype;
import org.coodex.concrete.message.Courier;
import org.coodex.util.GenericTypeHelper;

public abstract class CourierPrototype<M extends Serializable>
implements Courier<M> {
    private final String destination;
    private final String queue;
    private final Type topicType;
    private final Type messageType;
    private AbstractTopicPrototype<M> topic;

    public CourierPrototype(String queue, String destination, Type topicType) {
        this.destination = destination;
        this.queue = queue;
        this.topicType = topicType;
        this.messageType = GenericTypeHelper.solveFromType(AbstractTopic.class.getTypeParameters()[0], (Type)topicType);
    }

    protected abstract void afterTopicAssociation();

    @Override
    public void associate(AbstractTopicPrototype<M> topic) {
        this.topic = topic;
        this.afterTopicAssociation();
    }

    protected AbstractTopicPrototype<M> getTopic() {
        return this.topic;
    }

    public Type getTopicType() {
        return this.topicType;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getQueue() {
        return this.queue;
    }

    public Type getMessageType() {
        return this.messageType;
    }
}

