/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.message;

import java.io.Serializable;
import org.coodex.concrete.common.IF;
import org.coodex.concrete.message.AbstractTopicPrototype;
import org.coodex.concrete.message.Courier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTopicPrototype<M extends Serializable>
extends AbstractTopicPrototype<M> {
    private static final Logger log = LoggerFactory.getLogger(AbstractTopicPrototype.class);
    private boolean sending = false;

    public DefaultTopicPrototype(Courier<M> courier) {
        super(courier);
    }

    public void publish(M message) {
        IF.isNull(message, "message MUST NOT null.");
        if (!this.sending) {
            try {
                this.sending = true;
                this.getCourier().deliver(message);
            }
            finally {
                this.sending = false;
            }
        }
    }
}

