/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.message;

import java.io.Serializable;
import java.util.Set;
import org.coodex.concrete.message.AbstractTokenBasedMessageFilter;
import org.coodex.concrete.message.AbstractTopicPrototype;
import org.coodex.concrete.message.Courier;
import org.coodex.concrete.message.MessageFilter;
import org.coodex.concrete.message.Observer;
import org.coodex.concrete.message.Subscription;
import org.coodex.concrete.message.TBMContainer;
import org.coodex.concrete.message.TokenBasedTopic;
import org.coodex.concrete.message.Topic;
import org.coodex.concrete.message.Topics;
import org.coodex.util.Common;
import org.coodex.util.GenericTypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenBasedTopicPrototype<M extends Serializable>
extends AbstractTopicPrototype<M>
implements TokenBasedTopic<M> {
    private static final Logger log = LoggerFactory.getLogger(TokenBasedTopicPrototype.class);
    private Topic<Id<M>> idWrapper = (Topic)Topics.get(new GenericTypeHelper.GenericType<Topic<Id<M>>>(this.getClass()){}.getType(), this.getQueue());
    private Topic<TokenConfirm<M>> tokenConfirmTopic = (Topic)Topics.get(new GenericTypeHelper.GenericType<Topic<TokenConfirm<M>>>(this.getClass()){}.getType(), this.getQueue());
    private Topic<ConsumedNotify> consumedNotifyTopic = (Topic)Topics.get(new GenericTypeHelper.GenericType<Topic<ConsumedNotify>>(){}.getType(), this.getQueue());

    public TokenBasedTopicPrototype(Courier<M> courier) {
        super(courier);
        this.idWrapper.subscribe(new Observer<Id<M>>(){

            public void update(Id<M> message) throws Throwable {
                TokenBasedTopicPrototype.this.doFilter(message);
            }
        });
        this.tokenConfirmTopic.subscribe(new Observer<TokenConfirm<M>>(){

            public void update(TokenConfirm<M> message) throws Throwable {
                TBMContainer.getInstance().push(message, (Topic<ConsumedNotify>)TokenBasedTopicPrototype.this.consumedNotifyTopic);
            }
        });
        this.consumedNotifyTopic.subscribe((Observer)new Observer<ConsumedNotify>(){

            public void update(ConsumedNotify message) throws Throwable {
                TBMContainer.getInstance().remove(message);
            }
        });
    }

    private void doFilter(Id<M> message) {
        Set observers = this.getObservers();
        for (Observer observer : observers) {
            if (observer instanceof AbstractTokenBasedMessageFilter) {
                AbstractTokenBasedMessageFilter messageFilter = (AbstractTokenBasedMessageFilter)observer;
                try {
                    if (!messageFilter.handle(message.getMessage())) continue;
                    this.tokenConfirmTopic.publish(new TokenConfirm<M>(messageFilter.getTokenId(), message));
                }
                catch (Throwable th) {
                    log.warn("filter failed: {}", (Object)th.getLocalizedMessage(), (Object)th);
                }
                continue;
            }
            log.warn("WTF {} ?", observer);
        }
    }

    @Override
    public void notify(M message) {
    }

    @Override
    public Subscription subscribe(Observer<M> observer) {
        if (observer instanceof MessageFilter) {
            return this.subscribe((MessageFilter)observer);
        }
        throw new RuntimeException("TokenBasedTopic must subscribed by a MessageFilter");
    }

    public void publish(M message) {
        this.idWrapper.publish(new Id<M>(message));
    }

    @Override
    public Subscription subscribe(MessageFilter<M> messageFilter) {
        return super.subscribe(this.getObserver(messageFilter));
    }

    private Observer<M> getObserver(final MessageFilter<M> messageFilter) {
        return messageFilter instanceof AbstractTokenBasedMessageFilter ? (AbstractTokenBasedMessageFilter)messageFilter : new AbstractTokenBasedMessageFilter<M>(){

            public boolean handle(M message) {
                return messageFilter.handle(message);
            }
        };
    }

    public static class TokenConfirm<M extends Serializable>
    extends Id<M> {
        private String tokenId;

        public TokenConfirm() {
        }

        TokenConfirm(String tokenId, Id<M> message) {
            this.tokenId = tokenId;
            this.setId(message.getId());
            this.setMessage(message.getMessage());
        }

        public String getTokenId() {
            return this.tokenId;
        }

        public void setTokenId(String tokenId) {
            this.tokenId = tokenId;
        }
    }

    public static class Id<M extends Serializable>
    implements Serializable {
        private String id;
        private M message;

        public Id() {
        }

        public Id(M message) {
            this.id = Common.getUUIDStr();
            this.message = message;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public M getMessage() {
            return this.message;
        }

        public void setMessage(M message) {
            this.message = message;
        }
    }

    public static class ConsumedNotify
    implements Serializable {
        private String id;
        private String tokenId;

        public ConsumedNotify() {
        }

        public ConsumedNotify(String id, String tokenId) {
            this.id = id;
            this.tokenId = tokenId;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getTokenId() {
            return this.tokenId;
        }

        public void setTokenId(String tokenId) {
            this.tokenId = tokenId;
        }
    }
}

