/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.couriers.jms;

import java.io.Serializable;
import java.lang.reflect.Type;
import javax.jms.JMSException;
import org.coodex.concrete.couriers.jms.JMSFacade;
import org.coodex.concrete.message.CourierPrototype;
import org.coodex.util.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSCourierPrototype<M extends Serializable>
extends CourierPrototype<M> {
    private static final Logger log = LoggerFactory.getLogger(JMSCourierPrototype.class);
    private final String driver;
    private final Singleton<JMSFacade> jmsFacadeSingleton = new Singleton((Singleton.Builder)new Singleton.Builder<JMSFacade>(){

        public JMSFacade build() {
            return new JMSFacade(JMSCourierPrototype.this.getQueue(), JMSCourierPrototype.this.driver, String.format("%s@%s", JMSCourierPrototype.this.getTopicType().toString(), JMSCourierPrototype.this.getQueue()), o -> JMSCourierPrototype.this.getTopic().notify((Serializable)o), JMSCourierPrototype.this.getMessageType());
        }
    });
    private boolean consumer = false;

    public JMSCourierPrototype(String queue, String destination, Type topicType) {
        super(queue, destination, topicType);
        this.driver = this.getDriverFromDestination(destination);
    }

    protected void afterTopicAssociation() {
        this.jmsFacadeSingleton.get();
    }

    private String getDriverFromDestination(String destination) {
        return destination.substring("jms::".length());
    }

    public void deliver(M message) {
        ((JMSFacade)this.jmsFacadeSingleton.get()).publish((Serializable)message);
    }

    public synchronized boolean isConsumer() {
        return this.consumer;
    }

    public synchronized void setConsumer(boolean consumer) {
        if (consumer != this.consumer) {
            try {
                ((JMSFacade)this.jmsFacadeSingleton.get()).setConsumer(consumer);
                this.consumer = consumer;
            }
            catch (JMSException e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }
}

