/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.couriers.jms;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.couriers.jms.ConnectionFactoryProvider;
import org.coodex.concrete.message.Serializer;
import org.coodex.concrete.message.Topics;
import org.coodex.util.Common;
import org.coodex.util.LazySelectableServiceLoader;
import org.coodex.util.SingletonMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JMSFacade {
    private static final LazySelectableServiceLoader<String, ConnectionFactoryProvider> CONNECTION_FACTORY_PROVIDER_SELECTABLE_SERVICE_LOADER = new LazySelectableServiceLoader<String, ConnectionFactoryProvider>(){};
    private static final SingletonMap<String, ConnectionFactory> connectionFactorySingletonMap = new SingletonMap(key -> {
        ConnectionFactoryProvider cfp = (ConnectionFactoryProvider)CONNECTION_FACTORY_PROVIDER_SELECTABLE_SERVICE_LOADER.select(key);
        if (cfp == null) {
            throw new RuntimeException("no ConnectionFactoryProvider found for :" + key);
        }
        return cfp.build((String)key);
    });
    private static final Logger log = LoggerFactory.getLogger(JMSFacade.class);
    private final String name;
    private final String driver;
    private final String topicName;
    private final String userName;
    private final String password;
    private final MessageListener messageListener;
    private final Type messageType;
    private final Serializer serializer;
    private ConnectionFactory connectionFactory;
    private Connection connection;
    private Session session;
    private Destination destination;
    private MessageProducer producer;
    private MessageConsumer consumer;

    JMSFacade(String name, String driver, String topicName, ObjectListener objectListener, Type messageType) {
        this.name = name;
        this.driver = driver;
        this.topicName = topicName;
        this.messageType = messageType;
        this.messageListener = message -> {
            if (message instanceof ObjectMessage) {
                objectListener.receive(this.deserialize((ObjectMessage)message));
            }
        };
        this.connectionFactory = (ConnectionFactory)connectionFactorySingletonMap.get((Object)driver);
        this.userName = ConcreteHelper.getString((String)"queue", (String)name, (String)"username");
        this.password = ConcreteHelper.getString((String)"queue", (String)name, (String)"password");
        this.serializer = Topics.getSerializer((String)ConcreteHelper.getString((String)"queue", (String)name, (String)"serializer"));
        try {
            this.connect();
        }
        catch (JMSException e) {
            this.reconnect();
        }
    }

    void publish(Serializable message) {
        if (message == null) {
            throw new NullPointerException("message is null.");
        }
        if (this.producer != null) {
            try {
                this.producer.send((Message)this.session.createObjectMessage((Serializable)this.serializer.serialize(message)));
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new RuntimeException("cannot publish message, because connection is failed.");
        }
    }

    void setConsumer(boolean isConsumer) throws JMSException {
        if (isConsumer && this.consumer == null) {
            this.consumer = this.session.createConsumer(this.destination, null, false);
            this.consumer.setMessageListener(this.messageListener);
        } else if (!isConsumer && this.consumer != null) {
            try {
                this.consumer.close();
            }
            finally {
                this.consumer = null;
            }
        }
    }

    private Object deserialize(ObjectMessage message) {
        try {
            Serializable serializable = message.getObject();
            if (serializable instanceof byte[]) {
                return this.serializer.deserialize((byte[])serializable, this.messageType);
            }
            throw new RuntimeException("wrong message type: " + (serializable == null ? null : serializable.getClass().toString()));
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
    }

    private void reconnect() {
        this.clear();
        ConcreteHelper.getScheduler((String)"jms.reconnect").schedule(() -> {
            try {
                this.connect();
            }
            catch (JMSException e) {
                log.info("{}: connect {} failed: {}. retry...", new Object[]{this.name, this.driver, e.getLocalizedMessage()});
                this.reconnect();
            }
        }, 5L, TimeUnit.SECONDS);
    }

    private void connect() throws JMSException {
        this.connection = Common.isBlank((String)this.userName) ? this.connectionFactory.createConnection() : this.connectionFactory.createConnection(this.userName, this.password);
        this.connection.setExceptionListener(e -> this.reconnect());
        this.connection.start();
        this.session = this.connection.createSession(false, 1);
        this.destination = this.session.createTopic(this.topicName);
        this.producer = this.session.createProducer(this.destination);
    }

    private void clear() {
        if (this.connection != null) {
            try {
                this.producer.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            try {
                this.consumer.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            try {
                this.session.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            try {
                this.connection.stop();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            try {
                this.connection.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            this.producer = null;
            this.consumer = null;
            this.session = null;
            this.connection = null;
        }
    }

    static interface ObjectListener {
        public void receive(Object var1);
    }
}

