/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.couriers.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.BuiltinExchangeType;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Type;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.message.CourierPrototype;
import org.coodex.concrete.message.Serializer;
import org.coodex.concrete.message.Topics;
import org.coodex.util.Common;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitMQCourierPrototype<M extends Serializable>
extends CourierPrototype<M> {
    public static final String PREFIX_RABBITMQ = "rabbitmq";
    public static final String KEY_VIRTUAL_HOST = "virtualHost";
    public static final String KEY_HOST = "host";
    public static final String KEY_PORT = "port";
    public static final String KEY_SSL = "ssl";
    public static final String EXCHANGER_NAME = "org.coodex.concrete.topics";
    private static final Logger log = LoggerFactory.getLogger(RabbitMQCourierPrototype.class);
    private final Serializer serializer;
    private Connection connection;
    private Channel channel;
    private String routingKey;

    public RabbitMQCourierPrototype(String queue, String destination, Type topicType) {
        super(queue, destination, topicType);
        this.routingKey = String.format("%s@%s", this.getTopicType().toString(), queue);
        try {
            ConnectionFactory connectionFactory = new ConnectionFactory();
            if (destination.equalsIgnoreCase(PREFIX_RABBITMQ)) {
                connectionFactory.setVirtualHost(ConcreteHelper.getString((String)"queue", (String)queue, (String)KEY_VIRTUAL_HOST));
                connectionFactory.setHost(ConcreteHelper.getString((String)"queue", (String)queue, (String)KEY_HOST));
                try {
                    connectionFactory.setPort(Integer.valueOf(ConcreteHelper.getString((String)"queue", (String)queue, (String)KEY_PORT)).intValue());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (Common.toBool((String)ConcreteHelper.getString((String)"queue", (String)queue, (String)KEY_SSL), (boolean)false)) {
                    connectionFactory.useSslProtocol();
                }
            } else {
                connectionFactory.setUri(destination.substring(PREFIX_RABBITMQ.length() + 1));
                if (Common.isBlank((String)connectionFactory.getVirtualHost())) {
                    connectionFactory.setVirtualHost("/");
                }
            }
            String username = ConcreteHelper.getString((String)"queue", (String)queue, (String)"username");
            String password = ConcreteHelper.getString((String)"queue", (String)queue, (String)"password");
            this.serializer = Topics.getSerializer((String)ConcreteHelper.getString((String)"queue", (String)queue, (String)"serializer"));
            if (!Common.isBlank((String)username) || !Common.isBlank((String)password)) {
                connectionFactory.setUsername(username);
                connectionFactory.setPassword(password);
            }
            this.connection = connectionFactory.newConnection();
        }
        catch (Throwable th) {
            throw Common.runtimeException((Throwable)th);
        }
    }

    protected void afterTopicAssociation() {
        if (this.channel == null) {
            try {
                this.channel = this.connection.createChannel();
                this.channel.exchangeDeclare(EXCHANGER_NAME, BuiltinExchangeType.TOPIC);
                String queueName = this.channel.queueDeclare().getQueue();
                this.channel.queueBind(queueName, EXCHANGER_NAME, this.routingKey);
                this.channel.basicConsume(queueName, true, (Consumer)new DefaultConsumer(this.channel){

                    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                        try {
                            RabbitMQCourierPrototype.this.getTopic().notify(RabbitMQCourierPrototype.this.serializer.deserialize(body, RabbitMQCourierPrototype.this.getMessageType()));
                        }
                        catch (Throwable th) {
                            log.warn("notify error: {}", (Object)th.getLocalizedMessage(), (Object)th);
                        }
                    }
                });
            }
            catch (Throwable th) {
                throw Common.runtimeException((Throwable)th);
            }
        }
    }

    public void deliver(M message) {
        if (this.channel != null) {
            try {
                this.channel.basicPublish(EXCHANGER_NAME, this.routingKey, null, this.serializer.serialize(message));
            }
            catch (IOException e) {
                throw Common.runtimeException((Throwable)e);
            }
        } else {
            throw new RuntimeException("rabbitmq channel NOT build: " + this.getQueue());
        }
    }
}

