/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.couriers.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.BuiltinExchangeType;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import org.coodex.concrete.amqp.AMQPConnectionConfig;
import org.coodex.concrete.amqp.AMQPConnectionFacade;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.message.CourierPrototype;
import org.coodex.concrete.message.Serializer;
import org.coodex.concrete.message.Topics;
import org.coodex.util.Common;
import org.coodex.util.DigestHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitMQCourierPrototype<M extends Serializable>
extends CourierPrototype<M> {
    public static final String PREFIX_RABBITMQ = "rabbitmq";
    public static final String KEY_VIRTUAL_HOST = "virtualHost";
    public static final String KEY_HOST = "host";
    public static final String KEY_PORT = "port";
    public static final String KEY_SSL = "ssl";
    public static final String KEY_ROUTING_KEY = "routingKey";
    public static final String KEY_EXCHANGER = "exchanger";
    public static final String KEY_TTL = "ttl";
    public static final String DEFAULT_EXCHANGER_NAME = "org.coodex.concrete.topics";
    private static final Logger log = LoggerFactory.getLogger(RabbitMQCourierPrototype.class);
    private final Serializer serializer;
    private boolean consumer = false;
    private String consumerStr = null;
    private Connection connection;
    private String queueName;
    private Channel channel;
    private String routingKey;
    private String exchangerName;

    public RabbitMQCourierPrototype(String queue, String destination, Type topicType) {
        super(queue, destination, topicType);
        String customRoutingKey = ConcreteHelper.getString((String)"queue", (String)queue, (String)KEY_ROUTING_KEY);
        this.routingKey = Common.isBlank((String)customRoutingKey) ? DigestHelper.sha1((byte[])String.format("%s@%s", this.getTopicType().toString(), queue).getBytes(StandardCharsets.UTF_8)) : customRoutingKey + "@" + queue;
        try {
            AMQPConnectionConfig connectionConfig = new AMQPConnectionConfig();
            if (!destination.equalsIgnoreCase(PREFIX_RABBITMQ)) {
                connectionConfig.setUri(destination.substring(PREFIX_RABBITMQ.length() + 1));
            }
            connectionConfig.setHost(ConcreteHelper.getString((String)"queue", (String)queue, (String)KEY_HOST));
            try {
                connectionConfig.setPort(Integer.valueOf(Integer.parseInt(ConcreteHelper.getString((String)"queue", (String)queue, (String)KEY_PORT))));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            connectionConfig.setPassword(ConcreteHelper.getString((String)"queue", (String)queue, (String)"password"));
            connectionConfig.setUsername(ConcreteHelper.getString((String)"queue", (String)queue, (String)"username"));
            connectionConfig.setVirtualHost(ConcreteHelper.getString((String)"queue", (String)queue, (String)KEY_VIRTUAL_HOST));
            this.serializer = Topics.getSerializer((String)ConcreteHelper.getString((String)"queue", (String)queue, (String)"serializer"));
            this.exchangerName = ConcreteHelper.getString((String)"queue", (String)queue, (String)KEY_EXCHANGER);
            if (Common.isBlank((String)this.exchangerName)) {
                this.exchangerName = DEFAULT_EXCHANGER_NAME;
            }
            this.connection = AMQPConnectionFacade.getConnection((AMQPConnectionConfig)connectionConfig);
        }
        catch (Throwable th) {
            throw Common.runtimeException((Throwable)th);
        }
    }

    protected void afterTopicAssociation() {
        if (this.channel == null) {
            try {
                this.channel = this.connection.createChannel();
                this.channel.exchangeDeclare(this.exchangerName, BuiltinExchangeType.TOPIC);
                this.queueName = this.channel.queueDeclare().getQueue();
                this.channel.queueBind(this.queueName, this.exchangerName, this.routingKey);
            }
            catch (Throwable th) {
                throw Common.runtimeException((Throwable)th);
            }
        }
    }

    public void deliver(M message) {
        if (this.channel != null) {
            try {
                this.channel.basicPublish(this.exchangerName, this.routingKey, null, this.serializer.serialize(message));
            }
            catch (IOException e) {
                throw Common.runtimeException((Throwable)e);
            }
        } else {
            throw new RuntimeException("rabbitmq channel NOT build: " + this.getQueue());
        }
    }

    public synchronized boolean isConsumer() {
        return this.consumer;
    }

    public synchronized void setConsumer(boolean consumer) {
        block7: {
            if (consumer != this.consumer) {
                try {
                    if (consumer) {
                        this.consumerStr = this.channel.basicConsume(this.queueName, true, (Consumer)new DefaultConsumer(this.channel){

                            public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                                try {
                                    RabbitMQCourierPrototype.this.getTopic().notify(RabbitMQCourierPrototype.this.serializer.deserialize(body, RabbitMQCourierPrototype.this.getMessageType()));
                                }
                                catch (Throwable th) {
                                    log.warn("notify error: {}", (Object)th.getLocalizedMessage(), (Object)th);
                                }
                            }
                        });
                        break block7;
                    }
                    if (this.consumerStr == null) break block7;
                    try {
                        this.channel.basicCancel(this.consumerStr);
                    }
                    finally {
                        this.consumerStr = null;
                    }
                }
                catch (IOException e) {
                    log.error(e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
    }
}

