/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.client.dubbo;

import com.alibaba.dubbo.config.ApplicationConfig;
import com.alibaba.dubbo.config.ReferenceConfig;
import com.alibaba.dubbo.rpc.RpcContext;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.coodex.concrete.ClientHelper;
import org.coodex.concrete.client.ClientServiceContext;
import org.coodex.concrete.client.ClientTokenManagement;
import org.coodex.concrete.client.Destination;
import org.coodex.concrete.client.dubbo.DubboClientContext;
import org.coodex.concrete.client.impl.AbstractSyncInvoker;
import org.coodex.concrete.common.ConcreteContext;
import org.coodex.concrete.common.JSONSerializerFactory;
import org.coodex.concrete.common.RuntimeContext;
import org.coodex.concrete.common.ServiceContext;
import org.coodex.concrete.common.Subjoin;
import org.coodex.concrete.dubbo.DubboHelper;
import org.coodex.util.Common;
import org.coodex.util.SingletonMap;
import org.coodex.util.TypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DubboClientInvoker
extends AbstractSyncInvoker {
    private static final String CLIENT_AGENT = "concrete-dubbo-client-0.2.2";
    private static final Logger log = LoggerFactory.getLogger(DubboClientInvoker.class);
    private static SingletonMap<DubboCacheKey, Object> dubboClientInstances = new SingletonMap((SingletonMap.Builder)new SingletonMap.Builder<DubboCacheKey, Object>(){

        public Object build(DubboCacheKey key) {
            Destination destination = key.getDestination();
            String registries = ClientHelper.getString((String)destination.getIdentify(), (String)"registry");
            String application = ClientHelper.getString((String)destination.getIdentify(), (String)"name");
            ApplicationConfig applicationConfig = (ApplicationConfig)DubboHelper.applications.getInstance((Object)(application == null ? "concrete-dubbo-application" : application));
            List registryConfigs = DubboHelper.buildRegistryConfigs((String[])Common.toArray((String)registries, (String)",", (String[])new String[0]));
            ReferenceConfig reference = new ReferenceConfig();
            reference.setApplication(applicationConfig);
            reference.setRegistries(registryConfigs);
            reference.setInterface(DubboHelper.getDubboInterface((Class)key.clz));
            return reference.get();
        }
    });

    public DubboClientInvoker(Destination destination) {
        super(destination);
    }

    private static String mapToStr(Map<String, String> map) {
        StringBuffer buffer = new StringBuffer();
        for (String key : map.keySet()) {
            buffer.append("\n\t").append(key).append(": ").append(map.get(key));
        }
        return buffer.toString();
    }

    private static Map<String, String> subjoinToMap(Subjoin subjoin) {
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        for (String key : subjoin.keySet()) {
            map.put(key, subjoin.get(key));
        }
        return map;
    }

    private static Method findMethod(Class concreteClass, Method method) {
        Class proxyClass = DubboHelper.getDubboInterface((Class)concreteClass);
        for (Method m : proxyClass.getMethods()) {
            if (!m.getName().equalsIgnoreCase(method.getName()) || !Arrays.equals(method.getParameterTypes(), m.getParameterTypes())) continue;
            return m;
        }
        throw new RuntimeException("method not found. " + method);
    }

    protected Object execute(Class clz, Method method, Object[] args) throws Throwable {
        String content;
        ClientServiceContext context = (ClientServiceContext)ConcreteContext.getServiceContext();
        String tokenId = ClientTokenManagement.getTokenId((Destination)this.getDestination(), (String)context.getTokenId());
        if (!Common.isBlank((String)tokenId)) {
            RpcContext.getContext().setAttachment("CONCRETE-TOKEN-ID", tokenId);
        }
        RpcContext.getContext().setAttachment("user-agent", CLIENT_AGENT);
        RpcContext.getContext().setAttachment("subjoin", JSONSerializerFactory.getInstance().toJson((Object)context.getSubjoin()));
        if (log.isDebugEnabled()) {
            Map<String, String> map = DubboClientInvoker.subjoinToMap(context.getSubjoin());
            if (!Common.isBlank((String)tokenId)) {
                map.put("CONCRETE-TOKEN-ID", tokenId);
            }
            log.debug("subjoin before invoke: {}", (Object)DubboClientInvoker.mapToStr(map));
        }
        Map result = (Map)DubboClientInvoker.findMethod(clz, method).invoke(dubboClientInstances.getInstance((Object)new DubboCacheKey(this.getDestination(), clz)), args);
        if (log.isDebugEnabled()) {
            log.debug("subjoin after invoke: {}", (Object)DubboClientInvoker.mapToStr(result));
        }
        if (!Common.isBlank((String)(tokenId = (String)result.get("CONCRETE-TOKEN-ID")))) {
            ClientTokenManagement.setTokenId((Destination)this.getDestination(), (String)tokenId);
        }
        return (content = (String)result.get("result")) == null ? null : JSONSerializerFactory.getInstance().parse(content, TypeHelper.toTypeReference((Type)method.getGenericReturnType(), (Type[])new Type[]{clz}));
    }

    public ServiceContext buildContext(Class concreteClass, Method method) {
        return new DubboClientContext(this.getDestination(), RuntimeContext.getRuntimeContext((Method)method, (Class)concreteClass));
    }

    static class DubboCacheKey {
        private final Destination destination;
        private final Class clz;

        public DubboCacheKey(Destination destination, Class clz) {
            this.destination = destination;
            this.clz = clz;
        }

        public Destination getDestination() {
            return this.destination;
        }

        public Class getClz() {
            return this.clz;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DubboCacheKey that = (DubboCacheKey)o;
            if (!this.destination.equals((Object)that.destination)) {
                return false;
            }
            return this.clz.equals(that.clz);
        }

        public int hashCode() {
            int result = this.destination.hashCode();
            result = 31 * result + this.clz.hashCode();
            return result;
        }
    }
}

