/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.dubbo;

import com.alibaba.dubbo.common.bytecode.ClassGenerator;
import com.alibaba.dubbo.config.ApplicationConfig;
import com.alibaba.dubbo.config.RegistryConfig;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.SignatureAttribute;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.MemberValue;
import org.coodex.concrete.common.bytecode.javassist.JavassistHelper;
import org.coodex.concrete.dubbo.ProxyFor;
import org.coodex.util.Common;
import org.coodex.util.GenericType;
import org.coodex.util.SingletonMap;

public class DubboHelper {
    public static final SingletonMap<String, ApplicationConfig> applications = new SingletonMap((SingletonMap.Builder)new SingletonMap.Builder<String, ApplicationConfig>(){

        public ApplicationConfig build(String key) {
            return new ApplicationConfig(key);
        }
    });
    public static final String SUBJOIN = "subjoin";
    public static final String AGENT = "user-agent";
    public static final String RESULT = "result";
    private static SignatureAttribute.Type returnType = JavassistHelper.classType((Type)new GenericType<Map<String, String>>(){}.genericType(), DubboHelper.class);
    private static SingletonMap<Class, Class> dubboClasses = new SingletonMap((SingletonMap.Builder)new SingletonMap.Builder<Class, Class>(){

        public Class build(Class key) {
            try {
                String newClassName = key.getName() + "$DP";
                ClassPool classPool = ClassGenerator.getClassPool((ClassLoader)key.getClassLoader());
                CtClass ctClass = classPool.makeInterface(newClassName);
                ClassFile classFile = ctClass.getClassFile();
                ConstPool constPool = classFile.getConstPool();
                classFile.addAttribute(DubboHelper.proxyFor(key, constPool));
                classFile.setVersionToJava5();
                for (Method method : key.getMethods()) {
                    CtMethod ctMethod = new CtMethod(classPool.getCtClass(Map.class.getName()), method.getName(), DubboHelper.getParameterTypes(method.getParameterTypes()), ctClass);
                    ctMethod.setGenericSignature(new SignatureAttribute.MethodSignature(null, DubboHelper.getGenericParametersType(key, method), returnType, null).encode());
                    ctClass.addMethod(ctMethod);
                }
                return ctClass.toClass(key.getClassLoader(), key.getProtectionDomain());
            }
            catch (Throwable th) {
                throw th instanceof RuntimeException ? (RuntimeException)th : new RuntimeException(th.getLocalizedMessage(), th);
            }
        }
    });
    private static SingletonMap<String, RegistryConfig> registryConfigs = new SingletonMap((SingletonMap.Builder)new SingletonMap.Builder<String, RegistryConfig>(){

        public RegistryConfig build(String key) {
            try {
                URI uri = new URI(key);
                RegistryConfig registryConfig = new RegistryConfig();
                registryConfig.setProtocol(uri.getScheme());
                registryConfig.setAddress(uri.getHost());
                registryConfig.setPort(Integer.valueOf(uri.getPort()));
                String userInfo = uri.getUserInfo();
                if (!Common.isBlank((String)userInfo)) {
                    int index = userInfo.indexOf(58);
                    if (index > 0) {
                        registryConfig.setUsername(userInfo.substring(0, index));
                        registryConfig.setPassword(userInfo.substring(index + 1));
                    } else {
                        registryConfig.setUsername(userInfo);
                    }
                }
                return registryConfig;
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e.getLocalizedMessage(), e);
            }
        }
    });

    private static CtClass[] getParameterTypes(Class<?>[] parameterTypes) throws NotFoundException {
        ClassPool classPool = ClassPool.getDefault();
        ArrayList<CtClass> ctClasses = new ArrayList<CtClass>();
        for (Class<?> clz : parameterTypes) {
            ctClasses.add(classPool.getCtClass(clz.getName()));
        }
        return ctClasses.toArray(new CtClass[0]);
    }

    private static SignatureAttribute.Type[] getGenericParametersType(Class clz, Method method) {
        ArrayList<SignatureAttribute.Type> types = new ArrayList<SignatureAttribute.Type>();
        for (Type type : method.getGenericParameterTypes()) {
            types.add(JavassistHelper.classType((Type)type, (Class)clz));
        }
        return types.toArray(new SignatureAttribute.Type[0]);
    }

    private static AttributeInfo proxyFor(Class clz, ConstPool constPool) {
        Annotation annotation = new Annotation(ProxyFor.class.getName(), constPool);
        annotation.addMemberValue("value", (MemberValue)new ClassMemberValue(clz.getName(), constPool));
        AnnotationsAttribute attr = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
        attr.addAnnotation(annotation);
        return attr;
    }

    public static Class getDubboInterface(Class concreteService) {
        return (Class)dubboClasses.getInstance((Object)concreteService);
    }

    public static RegistryConfig buildRegistryConfig(String spec) {
        return (RegistryConfig)registryConfigs.getInstance((Object)spec);
    }

    public static List<RegistryConfig> buildRegistryConfigs(String[] specs) {
        ArrayList<RegistryConfig> configs = new ArrayList<RegistryConfig>();
        for (String spec : specs) {
            configs.add(DubboHelper.buildRegistryConfig(spec));
        }
        return configs;
    }
}

