/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.jaxrs;

import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInvocation;
import org.coodex.concrete.api.ConcreteService;
import org.coodex.concrete.common.ConcreteSPIFacade;
import org.coodex.concrete.common.ConcreteToolkit;
import org.coodex.concrete.common.DefinitionContext;
import org.coodex.concrete.jaxrs.JaxRSHelper;
import org.coodex.concrete.jaxrs.client.ClientInstanceFactory;
import org.coodex.concrete.jaxrs.client.Invoker;
import org.coodex.concrete.jaxrs.client.InvokerFactory;
import org.coodex.concrete.jaxrs.client.impl.JavaProxyClientInstanceFactory;
import org.coodex.concrete.jaxrs.struct.Unit;
import org.coodex.util.SPIFacade;

public final class Client {
    private static final SPIFacade<ClientInstanceFactory> BUILDER = new SPIFacade<ClientInstanceFactory>(){
        private ClientInstanceFactory defaultFactory = new JavaProxyClientInstanceFactory();

        protected ClientInstanceFactory getDefaultProvider() {
            return this.defaultFactory;
        }
    };
    private static Map<String, ConcreteService> INSTANCE_CACHE = new HashMap<String, ConcreteService>();
    private static final SPIFacade<InvokerFactory> INVOKER_FACTORY_SPI_FACADE = new ConcreteSPIFacade<InvokerFactory>(){};

    private static String getKey(Class<? extends ConcreteService> type, String domain) {
        return type.getName() + (domain == null ? "" : "@" + domain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends ConcreteService> T getBean(Class<? extends T> type, String domain) {
        if (type == null) {
            throw new NullPointerException("type MUST NOT NULL.");
        }
        Map<String, ConcreteService> map = INSTANCE_CACHE;
        synchronized (map) {
            String key = Client.getKey(type, domain);
            Object instance = INSTANCE_CACHE.get(key);
            if (instance == null) {
                instance = ((ClientInstanceFactory)BUILDER.getInstance()).create(type, domain);
                INSTANCE_CACHE.put(key, (ConcreteService)instance);
            }
            return (T)instance;
        }
    }

    public static <T extends ConcreteService> T getBean(Class<? extends T> type) {
        return Client.getBean(type, null);
    }

    protected static String getServiceRoot(String domain) {
        int len;
        String s = domain == null ? ConcreteToolkit.getProfile().getString("concrete.serviceRoot", "").trim() : ConcreteToolkit.getProfile().getString("concrete." + domain + ".serviceRoot", domain);
        char[] buf = s.toCharArray();
        for (len = buf.length; len > 0 && buf[len - 1] == '/'; --len) {
        }
        return new String(buf, 0, len);
    }

    public static Invoker getInvoker(String domain) {
        domain = Client.getServiceRoot(domain);
        for (InvokerFactory factory : INVOKER_FACTORY_SPI_FACADE.getAllInstances()) {
            if (!factory.accept(domain)) continue;
            return factory.getInvoker(domain);
        }
        throw new RuntimeException("unable found " + InvokerFactory.class.getName() + " service for [" + domain + "]");
    }

    public static final Unit getUnitFromContext(DefinitionContext context, MethodInvocation invocation) {
        return JaxRSHelper.getUnitFromContext((DefinitionContext)context, (MethodInvocation)invocation);
    }
}

