/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.jaxrs.client;

import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.StringTokenizer;
import org.aopalliance.intercept.MethodInvocation;
import org.coodex.concrete.common.ConcreteSPIFacade;
import org.coodex.concrete.jaxrs.ClassGenerator;
import org.coodex.concrete.jaxrs.JaxRSHelper;
import org.coodex.concrete.jaxrs.client.AbstractInvoker;
import org.coodex.concrete.jaxrs.client.ClientMethodInvocation;
import org.coodex.concrete.jaxrs.client.JSONSerializer;
import org.coodex.concrete.jaxrs.struct.Module;
import org.coodex.concrete.jaxrs.struct.Param;
import org.coodex.concrete.jaxrs.struct.Unit;
import org.coodex.pojomocker.POJOMocker;
import org.coodex.util.Common;
import org.coodex.util.SPIFacade;

public abstract class AbstractRemoteInvoker
extends AbstractInvoker {
    private static final SPIFacade<JSONSerializer> JSON_SERIALIZER_FACTORY = new ConcreteSPIFacade<JSONSerializer>(){};
    protected final String domain;

    public static JSONSerializer getJSONSerializer() {
        return (JSONSerializer)JSON_SERIALIZER_FACTORY.getInstance();
    }

    public AbstractRemoteInvoker(String domain) {
        this.domain = domain;
    }

    @Override
    protected MethodInvocation getInvocation(final Unit unit, final Object[] args, Object instance) {
        return new ClientMethodInvocation(instance, unit, args){

            public Object proceed() throws Throwable {
                if (ClassGenerator.FRONTEND_DEV_MODE) {
                    return POJOMocker.mock((Type)unit.getGenericReturnType(), (Class)((Module)unit.getDeclaringModule()).getInterfaceClass());
                }
                String path = AbstractRemoteInvoker.this.domain + ((Module)unit.getDeclaringModule()).getName();
                StringTokenizer stringTokenizer = new StringTokenizer(unit.getName(), "/");
                StringBuilder builder = new StringBuilder();
                while (stringTokenizer.hasMoreElements()) {
                    String node = stringTokenizer.nextToken();
                    if (Common.isBlank((String)node)) continue;
                    builder.append("/");
                    if (node.startsWith("{") && node.endsWith("}")) {
                        String paramName = new String(node.toCharArray(), 1, node.length() - 2);
                        for (int i = 0; i < unit.getParameters().length; ++i) {
                            Param param = unit.getParameters()[i];
                            if (!paramName.equals(param.getName())) continue;
                            node = AbstractRemoteInvoker.this.toStr(args[i]);
                            break;
                        }
                    }
                    builder.append(URLEncoder.encode(node, "UTF-8"));
                }
                path = path + builder.toString();
                Object toSubmit = null;
                if (args != null) {
                    for (int i = 0; i < unit.getParameters().length; ++i) {
                        Param param;
                        if (args[i] == null || JaxRSHelper.isPrimitive((Class)(param = unit.getParameters()[i]).getType()) && !JaxRSHelper.isBigString((Param)param)) continue;
                        toSubmit = args[i];
                        break;
                    }
                }
                return AbstractRemoteInvoker.this.invoke(path, unit, toSubmit);
            }
        };
    }

    protected abstract Object invoke(String var1, Unit var2, Object var3);

    protected String toStr(Object o) {
        if (o == null) {
            return null;
        }
        if (JaxRSHelper.isPrimitive(o.getClass())) {
            return o.toString();
        }
        return AbstractRemoteInvoker.getJSONSerializer().toJson(o);
    }
}

