/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.jaxrs.client.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.coodex.concrete.api.ConcreteService;
import org.coodex.concrete.jaxrs.Client;
import org.coodex.concrete.jaxrs.JaxRSHelper;
import org.coodex.concrete.jaxrs.client.ClientInstanceFactory;
import org.coodex.concrete.jaxrs.struct.Module;
import org.coodex.concrete.jaxrs.struct.Unit;

public class JavaProxyClientInstanceFactory
implements ClientInstanceFactory {
    @Override
    public <T extends ConcreteService> T create(final Class<? extends T> type, final String domain) {
        try {
            InvocationHandler handler = new InvocationHandler(){
                private final Module module;
                {
                    this.module = JaxRSHelper.getModule((Class)type);
                }

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if (method.getDeclaringClass() == Object.class) {
                        return method.invoke((Object)this, args);
                    }
                    int count = args == null ? 0 : args.length;
                    for (Unit unit : this.module.getUnits()) {
                        if (!method.getName().equals(unit.getMethod().getName()) || count != unit.getParameters().length) continue;
                        return Client.getInvoker(domain).invoke(unit, args, proxy);
                    }
                    throw new RuntimeException("method not found in [" + type.getName() + "]: [" + method.getName() + "] with " + count + " parameter(s).");
                }
            };
            return (T)((ConcreteService)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{type}, handler));
        }
        catch (Throwable th) {
            throw new RuntimeException(th.getLocalizedMessage(), th);
        }
    }
}

