/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.jaxrs.client.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.coodex.concrete.client.ClientCommon;
import org.coodex.concrete.client.MessagePojo;
import org.coodex.concrete.client.MessageSubscriber;
import org.coodex.concrete.common.ConcreteContext;
import org.coodex.concrete.common.ConcreteServiceLoader;
import org.coodex.concrete.common.JSONSerializerFactory;
import org.coodex.concrete.common.Subjoin;
import org.coodex.concrete.common.messages.Message;
import org.coodex.concrete.jaxrs.client.AbstractRemoteInvoker;
import org.coodex.concrete.jaxrs.client.JaxRSClientConfigBuilder;
import org.coodex.concrete.jaxrs.client.impl.AbstractCookieManager;
import org.coodex.concrete.jaxrs.struct.Unit;
import org.coodex.concurrent.ExecutorsHelper;
import org.coodex.util.Common;
import org.coodex.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaxRSClientInvoker
extends AbstractRemoteInvoker {
    private static final Logger log = LoggerFactory.getLogger(JaxRSClientInvoker.class);
    private static final Map<String, Client> clients = new HashMap<String, Client>();
    private static final Map<String, AbstractCookieManager> DOMAIN_COOKIE_MANAGERS = new HashMap<String, AbstractCookieManager>();
    private final Client client;
    private static final ServiceLoader<JaxRSClientConfigBuilder> BUILDER_SPI_FACADE = new ConcreteServiceLoader<JaxRSClientConfigBuilder>(){

        public JaxRSClientConfigBuilder getConcreteDefaultProvider() {
            return new JaxRSClientConfigBuilder(){

                @Override
                public Configuration buildConfig() {
                    return null;
                }
            };
        }
    };
    private ScheduledExecutorService executorService = ExecutorsHelper.newSingleThreadScheduledExecutor();
    private int pollingState = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final AbstractCookieManager getCookieManager(String domain) {
        Map<String, AbstractCookieManager> map = DOMAIN_COOKIE_MANAGERS;
        synchronized (map) {
            if (!DOMAIN_COOKIE_MANAGERS.keySet().contains(domain)) {
                DOMAIN_COOKIE_MANAGERS.put(domain, new AbstractCookieManager(){});
            }
        }
        return DOMAIN_COOKIE_MANAGERS.get(domain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Client getClient(String domain, SSLContext context, Configuration configuration) {
        Map<String, Client> map = clients;
        synchronized (map) {
            if (!clients.keySet().contains(domain)) {
                ClientBuilder clientBuilder = ClientBuilder.newBuilder();
                if (context != null) {
                    clientBuilder = clientBuilder.hostnameVerifier(new HostnameVerifier(){

                        @Override
                        public boolean verify(String s, SSLSession sslSession) {
                            return true;
                        }
                    }).sslContext(context);
                }
                if (configuration != null) {
                    clientBuilder = clientBuilder.withConfig(configuration);
                }
                clients.put(domain, clientBuilder.build());
            }
        }
        return clients.get(domain);
    }

    public JaxRSClientInvoker(String domain, SSLContext context, String tokenManagerKey) {
        super(domain, tokenManagerKey);
        this.client = JaxRSClientInvoker.getClient(domain, context, ((JaxRSClientConfigBuilder)BUILDER_SPI_FACADE.getInstance()).buildConfig());
    }

    private void executePoll() {
        if (this.pollingState == -1) {
            return;
        }
        this.executorService.schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block7: {
                    String url = JaxRSClientInvoker.this.domain + (JaxRSClientInvoker.this.domain.endsWith("/") ? "Concrete" : "/Concrete") + "/polling/15";
                    try {
                        Response response = JaxRSClientInvoker.this.request(url, "GET", null);
                        if (response.getStatus() == 404) {
                            log.warn("polling service not found: {}", (Object)JaxRSClientInvoker.this.domain);
                            JaxRSClientInvoker.this.pollingState = -1;
                            break block7;
                        }
                        if (response.getStatus() / 100 != 2) break block7;
                        try {
                            List messages = (List)response.readEntity((GenericType)new GenericType<List<MessagePojo<Object>>>(){});
                            for (Message message : messages) {
                                MessageSubscriber.next((String)message.getSubject(), (String)JSONSerializerFactory.getInstance().toJson(message.getBody()));
                            }
                        }
                        finally {
                            JaxRSClientInvoker.this.executePoll();
                        }
                    }
                    catch (Throwable e) {
                        log.error(e.getLocalizedMessage(), e);
                    }
                }
            }
        }, 50L, TimeUnit.MILLISECONDS);
    }

    private synchronized void polling() {
        if (this.pollingState == 0) {
            this.pollingState = 1;
            this.executePoll();
        }
    }

    @Override
    protected Object invoke(String url, Unit unit, Object toSubmit) throws Throwable {
        Response response = this.request(url, unit.getInvokeType(), toSubmit);
        String tokenId = response.getHeaderString("CONCRETE-TOKEN-ID");
        if (!Common.isBlank((String)tokenId)) {
            String tokenKey = Common.isBlank((String)this.tokenManagerKey) ? this.domain : this.tokenManagerKey;
            ClientCommon.setTokenId((String)tokenKey, (String)tokenId);
        }
        JaxRSClientInvoker.getCookieManager(this.domain).store(response.getCookies().values());
        this.polling();
        String body = (String)response.readEntity(String.class);
        return this.processResult(response.getStatus(), body, unit, response.getHeaders().keySet().contains("CONCRETE-ERROR-OCCURRED"), url);
    }

    private Response request(String url, String method, Object body) throws URISyntaxException {
        URI uri = new URI(url);
        Invocation.Builder builder = this.client.target(url).request();
        StringBuilder str = new StringBuilder();
        str.append("url: ").append(url).append("\n").append("method: ").append(method);
        Subjoin subjoin = ConcreteContext.getServiceContext() == null ? null : ConcreteContext.getServiceContext().getSubjoin();
        String tokenId = ClientCommon.getTokenId((String)(Common.isBlank((String)this.tokenManagerKey) ? this.domain : this.tokenManagerKey));
        if (subjoin != null || !Common.isBlank((String)tokenId)) {
            str.append("\nheaders:");
            if (subjoin != null) {
                for (String key : subjoin.keySet()) {
                    builder = builder.header(key, (Object)subjoin.get(key));
                    str.append("\n\t").append(key).append(": ").append(subjoin.get(key));
                }
            }
            if (!Common.isBlank((String)tokenId)) {
                builder = builder.header("CONCRETE-TOKEN-ID", (Object)tokenId);
                str.append("\n\t").append("CONCRETE-TOKEN-ID").append(": ").append(tokenId);
            }
        }
        StringBuilder cookies = new StringBuilder();
        for (Cookie cookie : JaxRSClientInvoker.getCookieManager(this.domain).load(uri.getPath())) {
            builder = builder.cookie(cookie);
            cookies.append(String.format("\n\tdomain: %s; name: %s; value: %s; path: %s, version: %d", cookie.getDomain(), cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getVersion()));
        }
        if (cookies.length() > 0) {
            str.append("\ncookies:").append(cookies.toString());
        }
        if (body != null) {
            str.append("\ncontent:\n").append(JaxRSClientInvoker.getJSONSerializer().toJson(body));
        }
        log.debug("requestInfo: \n{}", (Object)str.toString());
        return body == null ? builder.build(method).invoke() : builder.build(method, Entity.entity((Object)body, (MediaType)MediaType.APPLICATION_JSON_TYPE.withCharset(this.getEncodingCharset()))).invoke();
    }
}

