/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.jaxrs.client.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.jaxrs.client.SSLContextFactory;
import org.coodex.util.Common;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509CertsSSLContextFactory
implements SSLContextFactory {
    private static final Logger log = LoggerFactory.getLogger(X509CertsSSLContextFactory.class);
    private static final char[] HEXDIGITS = "0123456789abcdef".toCharArray();

    @Override
    public SSLContext getSSLContext(String domain) throws Throwable {
        if ((domain = this.getDomainName(domain)) == null) {
            return null;
        }
        SSLContext context = SSLContext.getInstance("SSL");
        context.init(null, this.getTrustManager(domain), new SecureRandom());
        return context;
    }

    private String getDomainName(String domain) {
        try {
            URL url = new URL(domain);
            return url.getHost() + (url.getPort() == -1 ? "" : "." + url.getPort());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private TrustManager[] getTrustManager(String domain) throws Throwable {
        String s = ConcreteHelper.getProfile().getString("trusted.certs.path." + domain, ConcreteHelper.getProfile().getString("trusted.certs.path"));
        if (s != null) {
            KeyStore trusted = KeyStore.getInstance(KeyStore.getDefaultType());
            trusted.load(null);
            this.loadCertificates(trusted, s);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trusted);
            return trustManagerFactory.getTrustManagers();
        }
        return null;
    }

    private void loadCertificates(KeyStore keyStore, String path) throws IOException, URISyntaxException, CertificateException {
        while (path.startsWith("\\") || path.startsWith("/")) {
            path = path.substring(1);
        }
        Enumeration<URL> certFiles = this.getClass().getClassLoader().getResources(path);
        if (certFiles == null) {
            return;
        }
        while (certFiles.hasMoreElements()) {
            String resource = URLDecoder.decode(certFiles.nextElement().getFile().replace("+", "%2B"), System.getProperty("file.encoding"));
            if (resource.indexOf(33) >= 0) continue;
            try {
                this.loadFromPath(keyStore, resource);
            }
            catch (Throwable t) {
                log.debug("error on load: {}", (Object)t.getLocalizedMessage());
            }
        }
    }

    private void loadFromPath(KeyStore keyStore, String resource) throws CertificateException, IOException {
        File file = new File(resource);
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        this.loadFromFile(file, keyStore, certificateFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromFile(File file, KeyStore keyStore, CertificateFactory certificateFactory) throws IOException {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                if (f.isDirectory()) continue;
                this.loadFromFile(f, keyStore, certificateFactory);
            }
        } else {
            FileInputStream fis = new FileInputStream(file);
            try {
                String alias = file.getName();
                int index = 0;
                while (keyStore.getCertificate(alias) != null) {
                    alias = file.getName() + '-' + ++index;
                }
                keyStore.setCertificateEntry(alias, certificateFactory.generateCertificate(fis));
                log.info("certificate loaded: {} from {}", (Object)alias, (Object)file.getAbsolutePath());
            }
            catch (Throwable e) {
                log.debug("unable load cert file: {}, {}", (Object)file.getAbsolutePath(), (Object)e.getLocalizedMessage());
            }
            finally {
                ((InputStream)fis).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveCertificateFromServer(String host, int port, String storePath) throws NoSuchAlgorithmException, KeyManagementException, IOException, CertificateEncodingException {
        int k;
        SSLContext context = SSLContext.getInstance("SSL");
        SavingTrustManager tm = new SavingTrustManager();
        context.init(null, new TrustManager[]{tm}, new SecureRandom());
        SSLSocketFactory factory = context.getSocketFactory();
        System.out.println("Opening connection to " + host + ":" + port + "...");
        SSLSocket socket = (SSLSocket)factory.createSocket(host, port);
        socket.setSoTimeout(10000);
        try {
            socket.startHandshake();
            socket.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (tm.chain == null || tm.chain.length == 0) {
            System.out.println("Could not obtain server certificate chain");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        System.out.println();
        System.out.println("Server sent " + tm.chain.length + " certificate(s):");
        System.out.println();
        MessageDigest sha1 = MessageDigest.getInstance("SHA1");
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        for (int i = 0; i < tm.chain.length; ++i) {
            X509Certificate cert = tm.chain[i];
            System.out.println(" " + (i + 1) + " Subject " + cert.getSubjectDN());
            System.out.println("   Issuer  " + cert.getIssuerDN());
            sha1.update(cert.getEncoded());
            System.out.println("   sha1    " + X509CertsSSLContextFactory.toHexString(sha1.digest()));
            md5.update(cert.getEncoded());
            System.out.println("   md5     " + X509CertsSSLContextFactory.toHexString(md5.digest()));
            System.out.println();
        }
        System.out.println("Enter certificate to add to trusted keystore or 'q' to quit: [1]");
        String line = reader.readLine().trim();
        try {
            k = line.length() == 0 ? 0 : Integer.parseInt(line) - 1;
        }
        catch (NumberFormatException e) {
            return;
        }
        if (k >= tm.chain.length || k < 0) {
            return;
        }
        X509Certificate cert = tm.chain[k];
        String name = host + "." + port;
        while (storePath.endsWith("/") || storePath.endsWith("\\")) {
            storePath = storePath.substring(0, storePath.length() - 1);
        }
        int index = 0;
        while (X509CertsSSLContextFactory.isExists(storePath + File.separatorChar + name + ".cer")) {
            name = host + "." + port + "-" + ++index;
        }
        File x = Common.getNewFile((String)(storePath + File.separatorChar + name + ".cer"));
        FileOutputStream os = new FileOutputStream(x);
        try {
            ((OutputStream)os).write(cert.getEncoded());
            os.flush();
        }
        finally {
            ((OutputStream)os).close();
        }
        System.out.println("certificate saved: " + x.getAbsolutePath());
    }

    private static boolean isExists(String name) {
        File f = new File(name);
        return f.exists();
    }

    private static String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 3);
        for (int n : bytes) {
            sb.append(HEXDIGITS[(n &= 0xFF) >> 4]);
            sb.append(HEXDIGITS[n & 0xF]);
            sb.append(' ');
        }
        return sb.toString();
    }

    static class SavingTrustManager
    implements X509TrustManager {
        private X509Certificate[] chain;

        SavingTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.chain = chain;
        }
    }
}

