/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.client.jaxrs;

import java.lang.reflect.Method;
import org.coodex.concrete.client.ClientServiceContext;
import org.coodex.concrete.client.Destination;
import org.coodex.concrete.common.Caller;
import org.coodex.concrete.common.RuntimeContext;
import org.coodex.concrete.common.SubjoinWrapper;
import org.coodex.concrete.common.struct.AbstractUnit;
import org.coodex.concrete.jaxrs.JaxRSHelper;
import org.coodex.concrete.jaxrs.struct.Module;
import org.coodex.concrete.jaxrs.struct.Unit;

public class JaxRSClientContext
extends ClientServiceContext {
    private static final String CONCRETE_JAXRS_USER_AGENT = "cocnrete-jaxrs-client 0.2.2";
    private static Caller CLIENT_CALLER = new Caller(){

        public String getAddress() {
            return "LOCAL";
        }

        public String getAgent() {
            return JaxRSClientContext.CONCRETE_JAXRS_USER_AGENT;
        }
    };

    private static Unit getUnit(Class clz, Method method) {
        Module module = JaxRSHelper.getModule((Class)clz, (String[])new String[0]);
        for (Unit unit : (Unit[])module.getUnits()) {
            if (!method.equals(unit.getMethod())) continue;
            return unit;
        }
        throw new RuntimeException("Cannot found jaxrs unit: " + clz + " " + method.getName());
    }

    public JaxRSClientContext(Destination destination, RuntimeContext context) {
        super(destination, context);
        this.caller = CLIENT_CALLER;
        this.model = "jaxrs_model";
        this.subjoin = new SubjoinWrapper.DefaultSubjoin();
        this.subjoin.add("User-Agent", CONCRETE_JAXRS_USER_AGENT);
    }

    protected AbstractUnit getUnit(RuntimeContext context) {
        return JaxRSClientContext.getUnit(context.getDeclaringClass(), context.getDeclaringMethod());
    }

    public Unit getJaxRSUnit() {
        return (Unit)this.getCurrentUnit();
    }
}

