/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.jaxrs.client.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Enumeration;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.jaxrs.client.SSLContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class X509CertsSSLContextFactory
implements SSLContextFactory {
    private static final Logger log = LoggerFactory.getLogger(X509CertsSSLContextFactory.class);

    @Override
    public SSLContext getSSLContext(String domain) throws Throwable {
        if ((domain = this.getDomainName(domain)) == null) {
            return null;
        }
        SSLContext context = SSLContext.getInstance("SSL");
        context.init(null, this.getTrustManager(domain), new SecureRandom());
        return context;
    }

    private String getDomainName(String domain) {
        try {
            URL url = new URL(domain);
            return url.getHost() + (url.getPort() == -1 ? "" : "." + url.getPort());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private TrustManager[] getTrustManager(String domain) throws Throwable {
        String s = ConcreteHelper.getProfile().getString("trusted.certs.path." + domain, ConcreteHelper.getProfile().getString("trusted.certs.path"));
        if (s != null) {
            KeyStore trusted = KeyStore.getInstance(KeyStore.getDefaultType());
            trusted.load(null);
            this.loadCertificates(trusted, s);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trusted);
            return trustManagerFactory.getTrustManagers();
        }
        return null;
    }

    private void loadCertificates(KeyStore keyStore, String path) throws IOException, URISyntaxException, CertificateException {
        while (path.startsWith("\\") || path.startsWith("/")) {
            path = path.substring(1);
        }
        Enumeration<URL> certFiles = this.getClass().getClassLoader().getResources(path);
        if (certFiles == null) {
            return;
        }
        while (certFiles.hasMoreElements()) {
            String resource = URLDecoder.decode(certFiles.nextElement().getFile().replace("+", "%2B"), System.getProperty("file.encoding"));
            if (resource.indexOf(33) >= 0) continue;
            try {
                this.loadFromPath(keyStore, resource);
            }
            catch (Throwable t) {
                log.debug("error on load: {}", (Object)t.getLocalizedMessage());
            }
        }
    }

    private void loadFromPath(KeyStore keyStore, String resource) throws CertificateException, IOException {
        File file = new File(resource);
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        this.loadFromFile(file, keyStore, certificateFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromFile(File file, KeyStore keyStore, CertificateFactory certificateFactory) throws IOException {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                if (f.isDirectory()) continue;
                this.loadFromFile(f, keyStore, certificateFactory);
            }
        } else {
            FileInputStream fis = new FileInputStream(file);
            try {
                String alias = file.getName();
                int index = 0;
                while (keyStore.getCertificate(alias) != null) {
                    alias = file.getName() + '-' + ++index;
                }
                keyStore.setCertificateEntry(alias, certificateFactory.generateCertificate(fis));
                log.info("certificate loaded: {} from {}", (Object)alias, (Object)file.getAbsolutePath());
            }
            catch (Throwable e) {
                log.debug("unable load cert file: {}, {}", (Object)file.getAbsolutePath(), (Object)e.getLocalizedMessage());
            }
            finally {
                ((InputStream)fis).close();
            }
        }
    }
}

