/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.client.jaxrs;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.coodex.concrete.AbstractClientException;
import org.coodex.concrete.ClientHelper;
import org.coodex.concrete.client.ClientTokenManagement;
import org.coodex.concrete.client.Destination;
import org.coodex.concrete.client.impl.AbstractSyncInvoker;
import org.coodex.concrete.client.jaxrs.JaxRSClientContext;
import org.coodex.concrete.client.jaxrs.JaxRSClientException;
import org.coodex.concrete.client.jaxrs.JaxRSInvokerFactory;
import org.coodex.concrete.common.ConcreteContext;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.DefinitionContext;
import org.coodex.concrete.common.ErrorInfo;
import org.coodex.concrete.common.RuntimeContext;
import org.coodex.concrete.common.ServiceContext;
import org.coodex.concrete.common.Subjoin;
import org.coodex.concrete.jaxrs.JaxRSHelper;
import org.coodex.concrete.jaxrs.struct.Module;
import org.coodex.concrete.jaxrs.struct.Param;
import org.coodex.concrete.jaxrs.struct.Unit;
import org.coodex.pojomocker.MockerFacade;
import org.coodex.util.Common;
import org.coodex.util.TypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaxRSInvoker
extends AbstractSyncInvoker {
    private static final Logger log = LoggerFactory.getLogger(JaxRSInvoker.class);
    private static ClientBuilder clientBuilder = ClientBuilder.newBuilder();
    private final Client client;

    JaxRSInvoker(Destination destination) {
        super(destination);
        this.client = JaxRSInvokerFactory.isSSL(destination.getLocation()) ? clientBuilder.hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        }).sslContext(ClientHelper.getSSLContext((Destination)destination)).build() : clientBuilder.build();
    }

    public static Invocation.Builder buildHeaders(Invocation.Builder builder, StringBuilder str, Subjoin subjoin, String tokenId) {
        if (subjoin != null || !Common.isBlank((String)tokenId)) {
            str.append("\nheaders:");
            if (subjoin != null) {
                for (String key : subjoin.keySet()) {
                    builder = builder.header(key, (Object)subjoin.get(key));
                    str.append("\n\t").append(key).append(": ").append(subjoin.get(key));
                }
            }
            if (!Common.isBlank((String)tokenId)) {
                builder = builder.header("CONCRETE-TOKEN-ID", (Object)tokenId);
                str.append("\n\t").append("CONCRETE-TOKEN-ID").append(": ").append(tokenId);
            }
        }
        return builder;
    }

    private static JaxRSClientException throwException(boolean errorOccurred, int code, String body, Unit unit, String url) {
        if (errorOccurred) {
            ErrorInfo errorInfo = (ErrorInfo)ClientHelper.getJSONSerializer().parse(body, ErrorInfo.class);
            return new JaxRSClientException(errorInfo.getCode(), errorInfo.getMsg(), url, unit.getInvokeType());
        }
        return new JaxRSClientException(code, body, url, unit.getInvokeType());
    }

    public static Object processResult(int code, String body, Unit unit, boolean errorOccurred, String url) {
        if (code >= 200 && code < 300) {
            return code == 204 || Void.TYPE.equals(unit.getReturnType()) ? null : ClientHelper.getJSONSerializer().parse(body, TypeHelper.toTypeReference((Type)unit.getGenericReturnType(), (Type[])new Type[]{((Module)unit.getDeclaringModule()).getInterfaceClass()}));
        }
        throw JaxRSInvoker.throwException(errorOccurred, code, body, unit, url);
    }

    public static Object getSubmitObject(Unit unit, Object[] args) {
        HashMap<String, Object> toSubmit = null;
        Param[] pojoParams = unit.getPojo();
        if (args != null) {
            switch (pojoParams.length) {
                case 0: {
                    break;
                }
                case 1: {
                    toSubmit = args[pojoParams[0].getIndex()];
                    break;
                }
                default: {
                    HashMap<String, Object> body = new HashMap<String, Object>();
                    for (Param param : pojoParams) {
                        body.put(param.getName(), args[param.getIndex()]);
                    }
                    toSubmit = body;
                }
            }
        }
        return toSubmit;
    }

    protected String getEncodingCharset() {
        String charset = ClientHelper.getString((String)this.getDestination().getIdentify(), (String)"jaxrs.charset");
        if (charset == null) {
            charset = "utf-8";
        }
        try {
            return Charset.forName(charset).displayName();
        }
        catch (UnsupportedCharsetException e) {
            log.warn("Unsupported charset: {}", (Object)charset);
            return "utf-8";
        }
    }

    protected String encode(String s, String charset) throws UnsupportedEncodingException {
        StringBuilder builder = new StringBuilder();
        block3: for (char c : s.toCharArray()) {
            switch (c) {
                case ' ': {
                    builder.append("%20");
                    continue block3;
                }
                default: {
                    builder.append(URLEncoder.encode(String.valueOf(c), charset));
                }
            }
        }
        return builder.toString();
    }

    protected String toStr(Object o) {
        if (o == null) {
            return null;
        }
        if (TypeHelper.isPrimitive(o.getClass())) {
            return o.toString();
        }
        return ClientHelper.getJSONSerializer().toJson(o);
    }

    protected Object execute(Class clz, Method method, Object[] args) throws Throwable {
        Unit unit = JaxRSHelper.getUnitFromContext((DefinitionContext)ConcreteHelper.getContext((Method)method, (Class)clz));
        if (ConcreteHelper.isDevModel((String)"jaxrs.client")) {
            return MockerFacade.mock((Method)unit.getMethod(), (Class[])new Class[]{((Module)unit.getDeclaringModule()).getInterfaceClass()});
        }
        String path = this.getDestination().getLocation();
        StringTokenizer stringTokenizer = new StringTokenizer(((Module)unit.getDeclaringModule()).getName() + "/" + unit.getName(), "/");
        StringBuilder builder = new StringBuilder();
        while (stringTokenizer.hasMoreElements()) {
            String node = stringTokenizer.nextToken();
            if (Common.isBlank((String)node)) continue;
            builder.append("/");
            if (node.startsWith("{") && node.endsWith("}")) {
                String paramName = new String(node.toCharArray(), 1, node.length() - 2);
                Param[] params = (Param[])unit.getParameters();
                for (int i = 0; i < params.length; ++i) {
                    Param param = params[i];
                    if (!paramName.equals(param.getName())) continue;
                    node = this.toStr(args[i]);
                    break;
                }
            }
            builder.append(this.encode(node, this.getEncodingCharset()));
        }
        path = path + builder.toString();
        Object toSubmit = JaxRSInvoker.getSubmitObject(unit, args);
        try {
            Response response = this.request(path, unit.getInvokeType(), toSubmit);
            String tokenId = response.getHeaderString("CONCRETE-TOKEN-ID");
            ClientTokenManagement.setTokenId((Destination)this.getDestination(), (String)tokenId);
            String body = (String)response.readEntity(String.class);
            if (log.isDebugEnabled()) {
                builder = new StringBuilder();
                builder.append("response\nstatus: ").append(response.getStatus()).append(";\nheaders:\n");
                for (String key : response.getHeaders().keySet()) {
                    builder.append("\t").append(key).append(": ").append(response.getHeaderString(key)).append("\n");
                }
                builder.append("result:\n").append(body);
                log.debug(builder.toString());
            }
            return JaxRSInvoker.processResult(response.getStatus(), body, unit, response.getHeaders().keySet().contains("CONCRETE-ERROR-OCCURRED"), path);
        }
        catch (AbstractClientException clientEx) {
            throw clientEx;
        }
        catch (Throwable th) {
            JaxRSClientException ce = new JaxRSClientException(-1, th.getLocalizedMessage(), path, unit.getInvokeType());
            ce.initCause(th);
            throw ce;
        }
    }

    private JaxRSClientContext getContext() {
        ServiceContext serviceContext = ConcreteContext.getServiceContext();
        if (serviceContext instanceof JaxRSClientContext) {
            return (JaxRSClientContext)serviceContext;
        }
        throw new RuntimeException(serviceContext + " is NOT JaxRSClientContext");
    }

    private Response request(String url, String method, Object body) throws URISyntaxException {
        URI uri = new URI(url);
        Invocation.Builder builder = this.client.target(url).request();
        StringBuilder str = new StringBuilder();
        str.append("url: ").append(url).append("\n").append("method: ").append(method);
        JaxRSClientContext context = this.getContext();
        Subjoin subjoin = context.getSubjoin();
        String tokenId = ClientTokenManagement.getTokenId((Destination)this.getDestination(), (String)context.getTokenId());
        builder = JaxRSInvoker.buildHeaders(builder, str, subjoin, tokenId);
        if (body != null && log.isDebugEnabled()) {
            str.append("\ncontent:\n").append(ClientHelper.getJSONSerializer().toJson(body));
        }
        log.debug("requestInfo: \n{}", (Object)str.toString());
        return body == null ? builder.build(method).invoke() : builder.build(method, Entity.entity((Object)body, (MediaType)MediaType.APPLICATION_JSON_TYPE.withCharset(this.getEncodingCharset()))).invoke();
    }

    public ServiceContext buildContext(Class concreteClass, Method method) {
        return new JaxRSClientContext(this.getDestination(), RuntimeContext.getRuntimeContext((Method)method, (Class)concreteClass));
    }
}

