/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.client.jaxrs;

import org.coodex.concrete.ClientHelper;
import org.coodex.concrete.client.AbstractDestinationFactory;
import org.coodex.concrete.client.Destination;
import org.coodex.concrete.client.jaxrs.JaxRSDestination;
import org.coodex.util.Common;

public class JaxRSDestinationFactory
extends AbstractDestinationFactory<JaxRSDestination> {
    public static boolean isJaxRS(String location) {
        return location.toLowerCase().startsWith("http://") || JaxRSDestinationFactory.isSSL(location);
    }

    public static boolean isSSL(String location) {
        return location.toLowerCase().startsWith("https://");
    }

    public Destination build(String module) {
        JaxRSDestination destination = (JaxRSDestination)this.init(new JaxRSDestination(), module);
        destination.setLogLevel(ClientHelper.getString((String)module, (String)"logLevel"));
        destination.setSsl(ClientHelper.getString((String)module, (String)"ssl"));
        destination.setCharset(ClientHelper.getString((String)module, (String)"jaxrs.charset"));
        return destination;
    }

    public boolean accept(String param) {
        String location = this.getLocation(param);
        return !Common.isBlank((String)location) && JaxRSDestinationFactory.isJaxRS(location);
    }
}

